/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.echo.progress;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.net.ClaimRewardResponseMessage;
import dev.ftb.mods.ftbechoes.net.SyncProgressMessage;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class TeamProgressManager
extends SavedData {
    private static final String SAVE_NAME = "ftbechoes_progress";
    private static final Codec<Map<UUID, TeamProgress>> PROGRESS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, TeamProgress.CODEC).xmap(HashMap::new, Map::copyOf);
    public static final Codec<TeamProgressManager> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)PROGRESS_CODEC.fieldOf("progress").forGetter(mgr -> mgr.progressMap)).apply((Applicative)builder, TeamProgressManager::new));
    private final Map<UUID, TeamProgress> progressMap;

    private TeamProgressManager(Map<UUID, TeamProgress> progressMap) {
        this.progressMap = progressMap;
    }

    public static TeamProgressManager get() {
        return TeamProgressManager.get(Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer()));
    }

    public static TeamProgressManager get(MinecraftServer server) {
        DimensionDataStorage dataStorage = Objects.requireNonNull(server.getLevel(Level.OVERWORLD)).getDataStorage();
        return (TeamProgressManager)dataStorage.computeIfAbsent(TeamProgressManager.factory(), SAVE_NAME);
    }

    private static SavedData.Factory<TeamProgressManager> factory() {
        return new SavedData.Factory(TeamProgressManager::createNew, TeamProgressManager::load, null);
    }

    private static TeamProgressManager createNew() {
        return new TeamProgressManager(new HashMap<UUID, TeamProgress>());
    }

    private static TeamProgressManager load(CompoundTag tag, HolderLookup.Provider provider) {
        return CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("progress")).resultOrPartial(err -> FTBEchoes.LOGGER.error("failed to deserialize progress data: {}", err)).orElse(TeamProgressManager.createNew());
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> {
            Tag t = (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).resultOrPartial(err -> FTBEchoes.LOGGER.error("failed to serialize progress data: {}", err)).orElse(new CompoundTag());
            tag.put("progress", t);
        });
    }

    public Optional<TeamProgress> getProgress(ServerPlayer sp) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayer(sp).map(this::getProgress);
    }

    public TeamProgress getProgress(Team team) {
        return TeamProgressManager.get().progressMap.computeIfAbsent(team.getTeamId(), k -> this.newProgress());
    }

    public boolean claimReward(ServerPlayer player, ResourceLocation echoId, int stageIdx) {
        return this.applyChange(player, (TeamProgress progress) -> progress.claimReward(echoId, player, stageIdx));
    }

    public boolean setStage(ServerPlayer player, ResourceLocation echoId, int stageIdx) {
        return this.applyChange(player, (TeamProgress progress) -> progress.setStage(echoId, stageIdx));
    }

    public boolean setStage(Team team, ResourceLocation echoId, int stageIdx) {
        return this.applyChange(team, (TeamProgress progress) -> progress.setStage(echoId, stageIdx));
    }

    public boolean resetReward(UUID playerId, ResourceLocation echoId, int stageIdx) {
        return this.applyChange(playerId, (TeamProgress progress) -> progress.resetReward(echoId, playerId, stageIdx));
    }

    public void tryCompleteStage(ServerPlayer sp, Team team, Echo echo) {
        TeamProgress teamProgress = TeamProgressManager.get().getProgress(team);
        int currentStage = teamProgress.getCurrentStage(echo.id());
        if (currentStage >= 0 && currentStage < echo.stages().size()) {
            EchoStage stage = echo.stages().get(currentStage);
            if (FTBEchoes.stageProvider().has((Player)sp, stage.requiredGameStage()) && this.completeStage(team, echo)) {
                this.notifyTeamCompletion(team, echo, currentStage);
            }
            stage.completionReward().ifPresent(reward -> {
                if (reward.autoclaim() && teamProgress.claimReward(echo.id(), sp, currentStage)) {
                    PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)SyncProgressMessage.forPlayer(teamProgress, sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new ClaimRewardResponseMessage(true, Optional.ofNullable(stage.completionRewardSummary())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.setDirty();
                }
            });
        }
    }

    private void notifyTeamCompletion(Team team, Echo echo, int currentStage) {
        team.getOnlineMembers().forEach(member -> {
            Vec3 vec = member.position();
            MutableComponent echoTitle = echo.title().copy().withStyle(ChatFormatting.YELLOW);
            MutableComponent stageTitle = echo.stages().get(currentStage).title().copy().withStyle(ChatFormatting.YELLOW);
            member.displayClientMessage((Component)Component.translatable((String)"ftbechoes.message.echo_stage_complete", (Object[])new Object[]{echoTitle, stageTitle}).withStyle(ChatFormatting.GREEN), false);
            if (currentStage == echo.stages().size() - 1) {
                member.displayClientMessage((Component)Component.translatable((String)"ftbechoes.message.echo_complete", (Object[])new Object[]{echoTitle}).withStyle(ChatFormatting.LIGHT_PURPLE), false);
                member.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.UI_TOAST_CHALLENGE_COMPLETE), SoundSource.PLAYERS, vec.x, vec.y, vec.z, 1.0f, 1.0f, 0L));
            } else {
                member.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.PLAYER_LEVELUP), SoundSource.PLAYERS, vec.x, vec.y, vec.z, 1.0f, 1.0f, 0L));
            }
        });
    }

    private boolean completeStage(Team team, Echo echo) {
        return this.applyChange(team, (TeamProgress progress) -> progress.completeStage(echo));
    }

    public boolean resetAllRewards(UUID playerId, ResourceLocation echoId) {
        return this.applyChange(playerId, (TeamProgress progress) -> progress.resetAllRewards(echoId, playerId));
    }

    public void consumeLimitedShopPurchase(ServerPlayer player, ShoppingKey key, int count, ShopData shopData) {
        this.applyChange(player, (TeamProgress progress) -> {
            progress.consumeShopStock((Player)player, key, count, shopData);
            return true;
        });
    }

    public boolean resetShopStock(ServerPlayer player, ResourceLocation echoId) {
        return this.applyChange(player, (TeamProgress progress) -> progress.resetShopStock(echoId));
    }

    public boolean resetShopStock(Team team, ResourceLocation echoId) {
        return this.applyChange(team, (TeamProgress progress) -> progress.resetShopStock(echoId));
    }

    private boolean applyChange(UUID playerId, Function<TeamProgress, Boolean> task) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayerID(playerId).map(team -> this.applyChange((Team)team, task)).orElse(false);
    }

    private boolean applyChange(ServerPlayer player, Function<TeamProgress, Boolean> task) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayer(player).map(team -> this.applyChange((Team)team, task)).orElse(false);
    }

    private boolean applyChange(Team team, Function<TeamProgress, Boolean> task) {
        TeamProgress teamProgress = this.progressMap.computeIfAbsent(team.getId(), k -> this.newProgress());
        if (task.apply(teamProgress).booleanValue()) {
            this.setDirty();
            team.getOnlineMembers().forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncProgressMessage.forPlayer(teamProgress, player), (CustomPacketPayload[])new CustomPacketPayload[0]));
            return true;
        }
        return false;
    }

    private TeamProgress newProgress() {
        this.setDirty();
        return TeamProgress.createNew();
    }

    public void injectProgressData(UUID teamId, TeamProgress progress) {
        this.progressMap.put(teamId, progress);
        this.setDirty();
        FTBTeamsAPI.api().getManager().getTeamByID(teamId).ifPresent(team -> team.getOnlineMembers().forEach(sp -> PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)SyncProgressMessage.forPlayer(progress, sp), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }
}

