/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.echo;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.echo.EchoStage;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record Echo(ResourceLocation id, Component title, List<EchoStage> stages, Optional<Component> allComplete) {
    private static final Codec<Echo> RAW_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(Echo::id), (App)ComponentSerialization.CODEC.fieldOf("title").forGetter(Echo::title), (App)EchoStage.CODEC.listOf().fieldOf("stages").forGetter(Echo::stages), (App)ComponentSerialization.CODEC.optionalFieldOf("all_complete").forGetter(Echo::allComplete)).apply((Applicative)builder, Echo::new));
    public static final Codec<Echo> CODEC = RAW_CODEC.validate(Echo::validate);
    public static final StreamCodec<RegistryFriendlyByteBuf, Echo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Echo::id, (StreamCodec)ComponentSerialization.STREAM_CODEC, Echo::title, (StreamCodec)EchoStage.STREAM_CODEC.apply(ByteBufCodecs.list()), Echo::stages, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ComponentSerialization.STREAM_CODEC), Echo::allComplete, Echo::new);

    public static Optional<Echo> fromJson(JsonElement json, RegistryAccess registryAccess) {
        return CODEC.decode((DynamicOps)registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)json).resultOrPartial(error -> FTBEchoes.LOGGER.error("JSON parse failure: {}", error)).map(Pair::getFirst);
    }

    private DataResult<Echo> validate() {
        HashSet<String> shopIds = new HashSet<String>();
        for (EchoStage stage : this.stages) {
            for (ShopData entry : stage.shopUnlocked()) {
                if (shopIds.add(entry.name())) continue;
                return DataResult.error(() -> String.format("duplicate shop key '%s' in echo id '%s'", entry.name(), this.id), (Object)this);
            }
        }
        return DataResult.success((Object)this);
    }

    public boolean hasAnyShopItems() {
        return this.stages.stream().anyMatch(s -> !s.shopUnlocked().isEmpty());
    }
}

