/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbechoes.command.EchoArgumentType;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgressManager;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ProgressCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"progress").requires(ctx -> ctx.hasPermission(2))).then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"echo", (ArgumentType)EchoArgumentType.echo()).then(Commands.literal((String)"set_stage").then(Commands.argument((String)"stage_idx", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ProgressCommand.setProgress((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), EchoArgumentType.get((CommandContext<CommandSourceStack>)ctx, "echo"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"stage_idx")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset_reward").executes(ctx -> ProgressCommand.resetRewardClaimed((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), EchoArgumentType.get((CommandContext<CommandSourceStack>)ctx, "echo"), -1))).then(Commands.argument((String)"stage_idx", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ProgressCommand.resetRewardClaimed((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), EchoArgumentType.get((CommandContext<CommandSourceStack>)ctx, "echo"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"stage_idx"))))))))).then(Commands.literal((String)"team").then(Commands.argument((String)"team", (ArgumentType)TeamArgument.create()).then(Commands.argument((String)"echo", (ArgumentType)EchoArgumentType.echo()).then(Commands.literal((String)"set_stage").then(Commands.argument((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ProgressCommand.setProgress((CommandContext<CommandSourceStack>)ctx, TeamArgument.get((CommandContext)ctx, (String)"team"), EchoArgumentType.get((CommandContext<CommandSourceStack>)ctx, "echo"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"stage"))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset-all").then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> ProgressCommand.resetAllProgress((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))))).then(Commands.literal((String)"team").then(Commands.argument((String)"team", (ArgumentType)TeamArgument.create()).executes(ctx -> ProgressCommand.resetAllProgress((CommandContext<CommandSourceStack>)ctx, TeamArgument.get((CommandContext)ctx, (String)"team"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset-stock").then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"echo", (ArgumentType)EchoArgumentType.echo()).executes(ctx -> ProgressCommand.resetShopStock((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), EchoArgumentType.get((CommandContext<CommandSourceStack>)ctx, "echo"))))))).then(Commands.literal((String)"team").then(Commands.argument((String)"team", (ArgumentType)TeamArgument.create()).then(Commands.argument((String)"echo", (ArgumentType)EchoArgumentType.echo()).executes(ctx -> ProgressCommand.resetShopStock((CommandContext<CommandSourceStack>)ctx, TeamArgument.get((CommandContext)ctx, (String)"team"), EchoArgumentType.get((CommandContext<CommandSourceStack>)ctx, "echo")))))));
    }

    private static int setProgress(CommandContext<CommandSourceStack> ctx, ServerPlayer player, Echo echo, int stageIdx) {
        if (TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer()).setStage(player, echo.id(), stageIdx)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.progress_changed", (Object[])new Object[]{player.getDisplayName(), echo.id().toString(), stageIdx}), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"ftbechoes.commands.progress_changed.failed").withStyle(ChatFormatting.RED));
        return 0;
    }

    private static int setProgress(CommandContext<CommandSourceStack> ctx, Team team, Echo echo, int stageIdx) {
        if (TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer()).setStage(team, echo.id(), stageIdx)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.progress_changed", (Object[])new Object[]{team.getShortName(), echo.id().toString(), stageIdx}), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"ftbechoes.commands.progress_changed.failed").withStyle(ChatFormatting.RED));
        return 0;
    }

    private static int resetRewardClaimed(CommandContext<CommandSourceStack> ctx, ServerPlayer player, Echo echo, int stageIdx) {
        if (stageIdx < 0) {
            if (TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer()).resetAllRewards(player.getUUID(), echo.id())) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.reward_reset_all", (Object[])new Object[]{player.getDisplayName(), echo.id().toString(), stageIdx}), false);
                return 1;
            }
        } else if (TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer()).resetReward(player.getUUID(), echo.id(), stageIdx)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.reward_reset", (Object[])new Object[]{player.getDisplayName(), echo.id().toString(), stageIdx}), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"ftbechoes.commands.reward_reset.failed").withStyle(ChatFormatting.RED));
        return 0;
    }

    private static int resetAllProgress(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        TeamProgressManager mgr = TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer());
        EchoManager.getServerInstance().getEchoes().forEach(echo -> {
            mgr.setStage(player, echo.id(), 0);
            mgr.resetAllRewards(player.getUUID(), echo.id());
        });
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.all_progress_reset", (Object[])new Object[]{player.getDisplayName()}), false);
        return 1;
    }

    private static int resetAllProgress(CommandContext<CommandSourceStack> ctx, Team team) {
        TeamProgressManager mgr = TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer());
        EchoManager.getServerInstance().getEchoes().forEach(echo -> {
            mgr.setStage(team, echo.id(), 0);
            Set<UUID> ids = team.isPartyTeam() ? team.getMembers() : Set.of(team.getOwner());
            ids.forEach(playerId -> mgr.resetAllRewards((UUID)playerId, echo.id()));
        });
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.all_progress_reset", (Object[])new Object[]{team.getColoredName()}), false);
        return 1;
    }

    private static int resetShopStock(CommandContext<CommandSourceStack> ctx, ServerPlayer player, Echo echo) {
        if (TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer()).resetShopStock(player, echo.id())) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.shop_stock_reset", (Object[])new Object[]{echo.id().toString()}), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"ftbechoes.commands.shop_stock_reset.failed", (Object[])new Object[]{echo.id().toString()}).withStyle(ChatFormatting.RED));
        return 0;
    }

    private static int resetShopStock(CommandContext<CommandSourceStack> ctx, Team team, Echo echo) {
        if (TeamProgressManager.get(((CommandSourceStack)ctx.getSource()).getServer()).resetShopStock(team, echo.id())) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"ftbechoes.commands.shop_stock_reset", (Object[])new Object[]{echo.id().toString()}), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"ftbechoes.commands.shop_stock_reset.failed", (Object[])new Object[]{echo.id().toString()}).withStyle(ChatFormatting.RED));
        return 0;
    }
}

