/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EchoArgumentType
implements ArgumentType<Echo> {
    private static final DynamicCommandExceptionType INVALID_ECHO = new DynamicCommandExceptionType(id -> Component.translatable((String)"ftbechoes.commands.invalid_echo", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType UNKNOWN_ECHO = new DynamicCommandExceptionType(id -> Component.translatable((String)"ftbechoes.commands.unknown_echo", (Object[])new Object[]{id}));

    public Echo parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        String s = EchoArgumentType.readResourceLocation(reader);
        try {
            return EchoManager.getInstance().getEcho(ResourceLocation.parse((String)s)).orElseThrow(() -> UNKNOWN_ECHO.create((Object)s));
        }
        catch (ResourceLocationException e) {
            reader.setCursor(start);
            throw INVALID_ECHO.create((Object)s);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Collection<Echo> echoes = EchoManager.getInstance().getEchoes();
        return SharedSuggestionProvider.suggest(echoes.stream().map(e -> e.id().toString()), (SuggestionsBuilder)builder);
    }

    public static EchoArgumentType echo() {
        return new EchoArgumentType();
    }

    public static Echo get(CommandContext<CommandSourceStack> context, String name) {
        return (Echo)context.getArgument(name, Echo.class);
    }

    public static String readResourceLocation(StringReader reader) {
        int start = reader.getCursor();
        while (reader.canRead() && ResourceLocation.isAllowedInResourceLocation((char)reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(start, reader.getCursor());
    }
}

