/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client;

import dev.ftb.mods.ftbechoes.block.entity.EchoProjectorBlockEntity;
import dev.ftb.mods.ftbechoes.client.PersistedClientData;
import dev.ftb.mods.ftbechoes.client.gui.EchoProgressInfo;
import dev.ftb.mods.ftbechoes.client.gui.EchoScreen;
import dev.ftb.mods.ftbechoes.client.gui.EchoSoundClipHandler;
import dev.ftb.mods.ftbechoes.client.gui.StageEntryRenderers;
import dev.ftb.mods.ftbechoes.client.render.EchoEntityRenderer;
import dev.ftb.mods.ftbechoes.client.render.EchoProjectorRenderer;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.net.ReturnTeamProgressToScreenMessage;
import dev.ftb.mods.ftbechoes.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbechoes.registry.ModEntityTypes;
import dev.ftb.mods.ftbechoes.shopping.ShoppingBasket;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.misc.SimpleToast;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@Mod(value="ftbechoes", dist={Dist.CLIENT})
public class FTBEchoesClient {
    private int altKeyTime = 0;

    public FTBEchoesClient(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.addListener(this::playerLoggedIn);
        NeoForge.EVENT_BUS.addListener(this::playerLoggedOut);
        NeoForge.EVENT_BUS.addListener(this::clientTick);
        modEventBus.addListener(this::registerRenderers);
        StageEntryRenderers.init();
    }

    private void clientTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!level.isClientSide() || !FTBTeamsAPI.api().isClientManagerLoaded()) {
            return;
        }
        if (ScreenWrapper.hasAltDown()) {
            ++this.altKeyTime;
            if (this.altKeyTime >= 40 && EchoSoundClipHandler.INSTANCE.isPlayingSound()) {
                EchoSoundClipHandler.INSTANCE.stopPlayingSound();
                Minecraft.getInstance().player.playSound(SoundEvents.COMPARATOR_CLICK, 0.7f, 0.5f);
            }
        } else {
            this.altKeyTime = 0;
        }
        PersistedClientData.get().save();
    }

    private void playerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        EchoManager.initClient();
    }

    private void playerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        EchoManager.shutdownClient();
        ShoppingBasket.CLIENT_INSTANCE.clear();
        PersistedClientData.refreshInstance();
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.ECHO_PROJECTOR.get(), EchoProjectorRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.ECHO.get(), EchoEntityRenderer::new);
    }

    public static void openEchoScreen(EchoProjectorBlockEntity projector) {
        ResourceLocation echoId = projector.getEchoId();
        BlockPos pos = projector.getBlockPos();
        if (echoId == null) {
            new EchoScreen(pos, null).openGui();
        } else {
            EchoManager.getClientInstance().getEcho(echoId).ifPresentOrElse(echo -> new EchoScreen(pos, (Echo)echo).openGui(), () -> Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)("Unknown echo: " + String.valueOf(echoId))).withStyle(ChatFormatting.RED), false));
        }
    }

    public static void onProgressUpdated() {
        EchoScreen screen = (EchoScreen)((Object)ClientUtils.getCurrentGuiAs(EchoScreen.class));
        if (screen != null) {
            screen.onProgressUpdated();
        }
    }

    public static void onTeamProgressProvided(UUID teamId, TeamProgress progress, Collection<ReturnTeamProgressToScreenMessage.PlayerNameEntry> playerNameEntries) {
        ScreenWrapper wrapper;
        BaseScreen baseScreen;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ScreenWrapper && (baseScreen = (wrapper = (ScreenWrapper)screen).getGui()) instanceof EchoProgressInfo) {
            EchoProgressInfo progressInfoScreen = (EchoProgressInfo)baseScreen;
            Map<UUID, Component> referencedPlayers = playerNameEntries.stream().collect(Collectors.toMap(ReturnTeamProgressToScreenMessage.PlayerNameEntry::playerId, ReturnTeamProgressToScreenMessage.PlayerNameEntry::playerName));
            progressInfoScreen.setProgress(teamId, progress, referencedPlayers);
        }
    }

    public static void notifyError(Component message, Component detail) {
        SimpleToast.error((Component)message, (Component)detail);
    }

    public static void notifySuccess(Component message, Component detail) {
        SimpleToast.info((Component)message, (Component)detail);
    }

    public static void onProjectorUpdated(EchoProjectorBlockEntity projector) {
        EchoScreen screen = (EchoScreen)((Object)ClientUtils.getCurrentGuiAs(EchoScreen.class));
        if (screen != null && screen.getProjectorPos().equals((Object)projector.getBlockPos())) {
            EchoManager.getClientInstance().getEcho(projector.getEchoId()).ifPresent(screen::setEcho);
        }
    }
}

