/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.block.entity;

import dev.ftb.mods.ftbechoes.client.FTBEchoesClient;
import dev.ftb.mods.ftbechoes.entity.EchoEntity;
import dev.ftb.mods.ftbechoes.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbechoes.registry.ModEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EchoProjectorBlockEntity
extends BlockEntity {
    @Nullable
    private ResourceLocation echoId;
    private UUID workerID = Util.NIL_UUID;

    public EchoProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.ECHO_PROJECTOR.get(), pos, state);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compound = super.getUpdateTag(provider);
        if (this.echoId != null) {
            compound.putString("echo_id", this.echoId.toString());
        }
        return compound;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        FTBEchoesClient.onProjectorUpdated(this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.echoId = tag.contains("echo_id", 8) ? ResourceLocation.parse((String)tag.getString("echo_id")) : null;
        this.workerID = tag.contains("worker_id") ? tag.getUUID("worker_id") : Util.NIL_UUID;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.echoId != null) {
            tag.putString("echo_id", this.echoId.toString());
        }
        if (this.workerID != Util.NIL_UUID) {
            tag.putUUID("worker_id", this.workerID);
        }
    }

    public void setRemoved() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        if (!this.workerID.equals(Util.NIL_UUID) && (level = this.level) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(this.workerID)) != null) {
            entity.discard();
        }
    }

    @Nullable
    public ResourceLocation getEchoId() {
        return this.echoId;
    }

    public void setEchoId(@Nullable ResourceLocation echoId) {
        this.echoId = echoId;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tickServer(ServerLevel serverLevel) {
        this.checkForEntity(serverLevel);
    }

    private void checkForEntity(ServerLevel level) {
        Entity currentEcho = level.getEntity(this.workerID);
        if (currentEcho == null && this.getEchoId() != null) {
            EchoEntity newEcho = new EchoEntity(ModEntityTypes.ECHO.get(), (Level)level);
            newEcho.setPos(Vec3.atCenterOf((Vec3i)this.getBlockPos()));
            newEcho.setEchoId(this.getEchoId());
            level.addFreshEntity((Entity)newEcho);
            this.workerID = newEcho.getUUID();
            this.setChanged();
        }
    }
}

