/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.ftb.mods.ftbbackups.Backups;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class BackupUtils {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final double KB_D = 1024.0;
    public static final double MB_D = 1048576.0;
    public static final double GB_D = 1.073741824E9;
    public static final double TB_D = 1.099511627776E12;

    public static long getSize(Path path) {
        final AtomicLong size = new AtomicLong(0L);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    Backups.LOGGER.error("getSize: skipped: {} ({})", (Object)file, (Object)exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        Backups.LOGGER.error("getSize: had trouble traversing dir: {} ({})", (Object)dir, (Object)exc);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError((Object)"walkFileTree will not throw IOException if the FileVisitor does not");
        }
        return size.get();
    }

    public static String formatSizeString(double b) {
        if (b >= 1.099511627776E12) {
            return String.format("%.1fTB", b / 1.099511627776E12);
        }
        if (b >= 1.073741824E9) {
            return String.format("%.1fGB", b / 1.073741824E9);
        }
        if (b >= 1048576.0) {
            return String.format("%.1fMB", b / 1048576.0);
        }
        if (b >= 1024.0) {
            return String.format("%.1fKB", b / 1024.0);
        }
        return (long)b + "B";
    }

    public static String formatSizeString(Path file) {
        return BackupUtils.formatSizeString(BackupUtils.getSize(file));
    }

    public static void writeJson(Writer writer, @Nullable JsonElement element, boolean prettyPrinting) {
        if (element == null || element.isJsonNull()) {
            try {
                writer.write("null");
            }
            catch (IOException ex) {
                throw new JsonIOException((Throwable)ex);
            }
            return;
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setLenient(true);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setSerializeNulls(true);
        if (prettyPrinting) {
            jsonWriter.setIndent("\t");
        }
        try {
            Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
        }
        catch (IOException ex) {
            throw new JsonIOException((Throwable)ex);
        }
    }

    public static void writeJson(Path jsonFile, @Nullable JsonElement element, boolean prettyPrinting) {
        try {
            Files.createDirectories(jsonFile.getParent(), new FileAttribute[0]);
            try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile.toFile()), StandardCharsets.UTF_8);
                 BufferedWriter writer = new BufferedWriter(output);){
                BackupUtils.writeJson(writer, element, prettyPrinting);
            }
        }
        catch (IOException e) {
            Backups.LOGGER.error("could not write JSON file {}: {} / {}", new Object[]{jsonFile, e.getClass(), e.getMessage()});
        }
    }

    public static JsonElement readJson(Path jsonFile) {
        JsonElement jsonElement;
        if (!Files.exists(jsonFile, new LinkOption[0])) {
            return JsonNull.INSTANCE;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsonFile.toFile()), StandardCharsets.UTF_8));
        try {
            JsonReader jsonReader = new JsonReader((Reader)reader);
            jsonReader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            jsonElement = element;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return JsonNull.INSTANCE;
            }
        }
        reader.close();
        return jsonElement;
    }
}

