/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake;

import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake.MalkuthEarthquake;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake.MalkuthEarthquakeSegment;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.rendering.renderers.QuadRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class MalkuthEarthquakeRenderer
extends EntityRenderer<MalkuthEarthquake> {
    public MalkuthEarthquakeRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(MalkuthEarthquake entity, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light) {
        super.render((Entity)entity, yaw, pticks, matrices, src, light);
        matrices.pushPose();
        List<MalkuthEarthquakeSegment> segments = entity.getSegments();
        for (MalkuthEarthquakeSegment segment : segments) {
            matrices.pushPose();
            Vec3 offset = segment.getOffset();
            float angle = segment.getAngle();
            float hangle = (float)Math.atan2(offset.x, offset.z);
            matrices.translate(offset.x, offset.y, offset.z);
            matrices.mulPose(Axis.YP.rotation(hangle));
            matrices.mulPose(Axis.XP.rotation(angle));
            float p = segment.getUpPercent(pticks);
            float up = -2.0f + 2.0f * p;
            matrices.translate(0.0f, up, 0.0f);
            MalkuthEarthquakeSegment.Type type = segment.getType();
            if (type.isModel()) {
                FDModel model = type.getModel().get();
                vertexConsumer = src.getBuffer(RenderType.entityTranslucent((ResourceLocation)type.getTexture()));
                model.render(matrices, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                Vec3 cr = offset.normalize().cross(entity.getDirectionAndLength().normalize());
                if (cr.y < 0.0) {
                    matrices.mulPose(Axis.YP.rotationDegrees(10.0f));
                } else {
                    matrices.mulPose(Axis.YP.rotationDegrees(-10.0f));
                }
                vertexConsumer = src.getBuffer(RenderType.text((ResourceLocation)type.getTexture()));
                QuadRenderer.start((VertexConsumer)vertexConsumer).pose(matrices).translate(0.0f, 1.0f, 0.0f).size(1.5f).light(0xF000F0).renderBack().direction(new Vec3(1.0, 0.0, 0.0)).render();
            }
            matrices.popPose();
        }
        matrices.popPose();
    }

    public ResourceLocation getTextureLocation(MalkuthEarthquake texture) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public boolean shouldRender(MalkuthEarthquake p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }
}

