/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_vertical_ray;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedBossBuddy;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChesedMovingVerticalRay
extends LivingEntity
implements AutoSerializable {
    public static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(ChesedMovingVerticalRay.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @SerializableField
    private float height;
    @SerializableField
    private ProjectileMovementPath path;
    @SerializableField
    private float damage;

    public ChesedMovingVerticalRay(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    public static ChesedMovingVerticalRay summon(Level level, Vec3 pos, ProjectileMovementPath movePath, float damage, float height) {
        ChesedMovingVerticalRay attack = new ChesedMovingVerticalRay(BossEntities.CHESED_VERTICAL_RAY_ATTACK.get(), level);
        attack.setPos(pos);
        attack.setDamage(damage);
        attack.setPath(movePath);
        attack.setHeight(height);
        movePath.tick((Entity)attack);
        level.addFreshEntity((Entity)attack);
        return attack;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.path == null) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.path.tick((Entity)this);
            if (this.path.isFinished()) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            this.doDamage();
            if (this.tickCount % 2 == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.LIGHTNING_RAY_PASS.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        } else {
            this.particles();
        }
    }

    private void particles() {
        Vec3 pos = this.position();
        for (int i = 0; i < 5; ++i) {
            BallParticleOptions options = BallParticleOptions.builder().color(0.3f, 1.0f, 1.0f, 1.0f).scalingOptions(0, 0, 20 + this.random.nextInt(3)).physics(false).size(0.5f).friction(0.9f).build();
            Vec3 speed = new Vec3((double)0.3f, 0.0, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f).add(0.0, (double)(this.random.nextFloat() * 0.1f), 0.0);
            this.level().addParticle((ParticleOptions)options, true, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        }
        pos = pos.add(0.0, (double)this.getHeight(), 0.0);
        float maxl = 2.0f;
        for (int i = 0; i < 2; ++i) {
            float l = this.random.nextFloat() * maxl;
            Vec3 add = new Vec3((double)l, 0.0, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f);
            BallParticleOptions options = BallParticleOptions.builder().color(0.3f, 1.0f, 1.0f, 1.0f).scalingOptions(0, 0, 20 + this.random.nextInt(3)).physics(false).size(0.25f + (1.0f - l / maxl) * 2.0f).build();
            this.level().addParticle((ParticleOptions)options, true, pos.x + add.x, pos.y, pos.z + add.z, 0.0, 0.0, 0.0);
        }
    }

    private void doDamage() {
        float damageRadius = 1.5f;
        AABB box = new AABB((double)(-damageRadius), 0.0, (double)(-damageRadius), (double)damageRadius, (double)this.getHeight(), (double)damageRadius).move(this.position());
        List list = this.level().getEntitiesOfClass(LivingEntity.class, box, BossUtil.entityInVerticalRadiusPredicate(this.position(), damageRadius));
        for (LivingEntity entity : list) {
            if (entity instanceof ChesedBossBuddy || entity instanceof ChesedMovingVerticalRay) continue;
            entity.hurt(BossDamageSources.CHESED_VERTICAL_RAY_SOURCE, this.getDamage());
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEIGHT, (Object)Float.valueOf(30.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (accessor == HEIGHT) {
            this.height = ((Float)this.entityData.get(HEIGHT)).floatValue();
        }
    }

    public void setHeight(float height) {
        this.entityData.set(HEIGHT, (Object)Float.valueOf(height));
        this.height = height;
    }

    public float getHeight() {
        return ((Float)this.entityData.get(HEIGHT)).floatValue();
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setPath(ProjectileMovementPath path) {
        this.path = path;
    }

    public ProjectileMovementPath getPath() {
        return this.path;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean save(CompoundTag tag) {
        this.autoSave(tag);
        return super.save(tag);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.autoLoad(tag);
        this.setHeight(this.height);
    }

    public boolean hurt(DamageSource src, float damage) {
        if (!src.is(DamageTypes.GENERIC_KILL) && !src.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            return false;
        }
        return super.hurt(src, damage);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getItemBySlot(EquipmentSlot p_21127_) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot p_21036_, ItemStack p_21037_) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.LEFT;
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

