/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_mini_ray;

import com.finderfeed.fdbosses.client.particles.chesed_attack_ray.ChesedRayOptions;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.client.particles.lightning_particle.LightningParticleOptions;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.AttributeUtil;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ChesedMiniRay
extends Entity
implements AutoSerializable {
    public static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.defineId(ChesedMiniRay.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int TIME_UNTIL_ATTACK = 25;
    public static final int ATTACK_TIME = 8;
    private ItemStack item;
    @SerializableField
    private UUID target;
    @SerializableField
    private UUID owner;

    public static ChesedMiniRay summon(Level level, LivingEntity target, ItemStack item, LivingEntity owner) {
        ChesedMiniRay chesedMiniRay = new ChesedMiniRay(BossEntities.CHESED_MINI_RAY.get(), level);
        chesedMiniRay.item = item;
        chesedMiniRay.target = target.getUUID();
        chesedMiniRay.owner = owner.getUUID();
        chesedMiniRay.entityData.set(TARGET, (Object)target.getId());
        Vec3 targetPos = target.position();
        Vec3 between = targetPos.subtract(owner.position()).multiply(1.0, 0.0, 1.0).normalize();
        float rndDistMod = Mth.clamp((float)(target.getBbWidth() * 3.0f), (float)2.0f, (float)10.0f) + level.random.nextFloat() * 2.0f;
        float rndOffsNum = level.random.nextBoolean() ? 1.0f : -1.0f;
        Vec3 randomOffset = between.multiply((double)rndDistMod, (double)rndDistMod, (double)rndDistMod).yRot(rndOffsNum * (float)Math.PI / 2.0f + -rndOffsNum * (float)Math.PI / 8.0f).add(0.0, 1.5 + (double)(level.random.nextFloat() * 2.0f), 0.0);
        Vec3 resultPos = targetPos.add(randomOffset);
        chesedMiniRay.setPos(resultPos);
        level.addFreshEntity((Entity)chesedMiniRay);
        return chesedMiniRay;
    }

    public ChesedMiniRay(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public void tick() {
        block5: {
            LivingEntity target;
            block3: {
                block4: {
                    super.tick();
                    if (this.level().isClientSide) break block3;
                    this.checkRemoved();
                    if (this.tickCount != 1) break block4;
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.CHESED_RAY_CHARGE.get(), SoundSource.NEUTRAL, 2.0f, 1.15f);
                    break block5;
                }
                if (this.tickCount != 25) break block5;
                this.attack();
                break block5;
            }
            if (this.tickCount == 25 && (target = this.getTarget()) != null) {
                this.attackParticles(this.getTargetPos(target, 0.0f));
            }
            if (this.tickCount < 25) {
                for (int i = 0; i < 10; ++i) {
                    BallParticleOptions options = BallParticleOptions.builder().friction(0.5f).size(0.25f).color(100 + this.random.nextInt(50), 255, 255).scalingOptions(3, 0, 10).build();
                    LightningParticleOptions lightningParticleOptions = LightningParticleOptions.builder().color(20, 150 + this.random.nextInt(50), 255).lifetime(10).maxLightningSegments(3).randomRoll(true).build();
                    this.level().addParticle((ParticleOptions)options, this.getX(), this.getY(), this.getZ(), (double)(this.level().random.nextFloat() * 0.25f) - 0.125, (double)(this.level().random.nextFloat() * 0.25f) - 0.125, (double)(this.level().random.nextFloat() * 0.25f) - 0.125);
                    if (!this.random.nextBoolean()) continue;
                    this.level().addParticle((ParticleOptions)lightningParticleOptions, this.getX(), this.getY(), this.getZ(), (double)(this.level().random.nextFloat() * 0.1f) - 0.05, (double)(this.level().random.nextFloat() * 0.1f) - 0.05, (double)(this.level().random.nextFloat() * 0.1f) - 0.05);
                }
            }
        }
    }

    private void attackParticles(Vec3 basePos) {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return;
        }
        Vec3 pos = this.position();
        Vec3 targetPos = this.getTargetPos(target, 0.0f);
        Vec3 dir = pos.subtract(targetPos);
        Matrix4f mat = new Matrix4f();
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mat, (Vec3)dir);
        int countOnCircle = 16;
        float angle = (float)Math.PI * 2 / (float)countOnCircle;
        int count = 16;
        for (int i = 0; i < countOnCircle; ++i) {
            for (int k = 0; k < count; ++k) {
                float currentAngle = (float)i * angle + this.random.nextFloat() * angle;
                Vec3 particleDirection = new Vec3(1.0, 0.0, 0.0).yRot(currentAngle);
                float p = (float)k / ((float)count - 1.0f);
                float size = 0.25f + p * 0.25f;
                float speedMod = (1.0f - p) * (2.0f + this.random.nextFloat() * 0.5f);
                BallParticleOptions options = BallParticleOptions.builder().friction(0.5f).size(size).color(100 + this.random.nextInt(50), 255, 255).scalingOptions(3, 0, 10).build();
                Vector3f v = new Vector3f((float)particleDirection.x, 3.0f, (float)particleDirection.z).normalize();
                float offsetRandom = this.random.nextFloat() * 0.5f;
                Vector3f v2 = new Vector3f((float)particleDirection.x * offsetRandom, 0.0f, (float)particleDirection.z * offsetRandom);
                Vector3f finalSpeed = mat.transformDirection(v);
                Vector3f finalPosOffset = mat.transformDirection(v2);
                Vec3 ppos = basePos.add((double)finalPosOffset.x, (double)finalPosOffset.y, (double)finalPosOffset.z);
                this.level().addParticle((ParticleOptions)options, true, ppos.x, ppos.y, ppos.z, (double)(finalSpeed.x * speedMod), (double)(finalSpeed.y * speedMod), (double)(finalSpeed.z * speedMod));
            }
        }
    }

    public void attack() {
        ServerLevel serverLevel;
        Level level = this.level();
        if (level instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).getEntity(this.owner)) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)level;
            LivingEntity target = this.getTarget();
            if (target == null) {
                return;
            }
            Vec3 end = this.getTargetPos(target, 0.0f);
            ChesedRayOptions options = ChesedRayOptions.builder().time(2, 2, 7).lightningColor(90, 180, 255).color(100, 255, 255).end(end).width(0.6f).build();
            FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)options, (Vec3)this.position(), (double)120.0);
            FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)BallParticleOptions.builder().size(5.0f).scalingOptions(1, 0, 2).color(150, 230, 255).build(), (Vec3)end, (double)120.0);
            PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(5.0f).amplitude(5.0f).inTime(0).stayTime(0).outTime(5).build(), (Vec3)end, (double)30.0);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.CHESED_LIGHTNING_RAY.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            this.hurtTarget(owner, target);
        }
    }

    public Vec3 getTargetPos(LivingEntity target, float pticks) {
        return target.getPosition(pticks).add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
    }

    public void checkRemoved() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.tickCount > 33) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            }
            if (this.target == null || this.owner == null) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            }
            if (serverLevel.getEntity(this.owner) == null) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            } else {
                Entity entity = serverLevel.getEntity(this.target);
                if (!(entity instanceof LivingEntity)) {
                    this.setRemoved(Entity.RemovalReason.DISCARDED);
                } else {
                    LivingEntity living = (LivingEntity)entity;
                    this.entityData.set(TARGET, (Object)living.getId());
                }
            }
        }
    }

    public LivingEntity getTarget() {
        if (this.level().isClientSide) {
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living;
            }
        } else {
            Entity entity = ((ServerLevel)this.level()).getEntity(this.target);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living;
            }
        }
        return null;
    }

    private void hurtTarget(LivingEntity owner, LivingEntity target) {
        AttributeInstance attribute = owner.getAttribute(Attributes.ATTACK_DAMAGE);
        double base = attribute.getBaseValue();
        Multimap map = AttributeUtil.getSortedModifiers((ItemStack)this.item, (EquipmentSlotGroup)EquipmentSlotGroup.MAINHAND);
        if (map.containsKey((Object)Attributes.ATTACK_DAMAGE)) {
            Collection attributes = map.get((Object)Attributes.ATTACK_DAMAGE);
            Map<AttributeModifier.Operation, List<AttributeModifier>> operationAttributes = this.modifierCollectionToOperationMap(attributes);
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.ADD_VALUE)) {
                base += mod.amount();
            }
            double damage = base;
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                damage += base * mod.amount();
            }
            for (AttributeModifier mod : operationAttributes.get(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                damage *= 1.0 + mod.amount();
            }
            float dmg = BossConfigs.BOSS_CONFIG.get().itemConfig.lightningStrikeDamagePercent / 100.0f;
            DamageSource damageSource = this.level().damageSources().mobAttack(owner);
            damage = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.level()), (ItemStack)this.item, (Entity)target, (DamageSource)damageSource, (float)((float)damage));
            target.setRemainingFireTicks(0);
            target.invulnerableTime = 0;
            if (target.hurt(damageSource, (float)(damage *= (double)dmg))) {
                int duration = BossConfigs.BOSS_CONFIG.get().itemConfig.lightningStrikeShockDuration;
                target.addEffect(new MobEffectInstance(BossEffects.SHOCKED, duration, 0));
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)target, (DamageSource)damageSource);
                target.invulnerableTime = 0;
            }
        }
    }

    private Map<AttributeModifier.Operation, List<AttributeModifier>> modifierCollectionToOperationMap(Collection<AttributeModifier> collection) {
        LinkedHashMap<AttributeModifier.Operation, List<AttributeModifier>> operationListMap = new LinkedHashMap<AttributeModifier.Operation, List<AttributeModifier>>();
        operationListMap.put(AttributeModifier.Operation.ADD_VALUE, new ArrayList());
        operationListMap.put(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, new ArrayList());
        operationListMap.put(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, new ArrayList());
        for (AttributeModifier mod : collection) {
            ((List)operationListMap.get(mod.operation())).add(mod);
        }
        return operationListMap;
    }

    protected void defineSynchedData(SynchedEntityData.Builder data) {
        data.define(TARGET, (Object)-1);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.item = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)tag.get("item")).get();
        this.autoLoad(tag);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        Tag item = this.item.save((HolderLookup.Provider)this.level().registryAccess());
        tag.put("item", item);
        this.autoSave(tag);
    }
}

