/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedEntity;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDFreeEntityRenderer;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.renderers.QuadRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Random;

public class ChesedRenderer
implements FDFreeEntityRenderer<ChesedEntity> {
    public static final ResourceLocation CHESED_RAY_PREPARE = FDBosses.location("textures/util/chesed_ray_prepare.png");
    public static final ResourceLocation FINAL_ATTACK_CRACKS = FDBosses.location("textures/util/chesed_wall_crack.png");

    public void render(ChesedEntity chesedEntity, float yaw, float pticks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        this.renderRayEffect(chesedEntity, yaw, pticks, poseStack, multiBufferSource, light);
        this.renderRockfallRayEffect(chesedEntity, yaw, pticks, poseStack, multiBufferSource, light);
        this.renderFinalAttackCracks(chesedEntity, yaw, pticks, poseStack, multiBufferSource, light);
        this.renderEarthquakeCastFffects(chesedEntity, yaw, pticks, poseStack, multiBufferSource, light);
    }

    private void renderEarthquakeCastFffects(ChesedEntity chesedEntity, float yaw, float pticks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        AnimationSystem system = chesedEntity.getAnimationSystem();
        AnimationTicker ticker = system.getTicker("EARTHQUAKE");
        if (ticker == null) {
            return;
        }
        float height = chesedEntity.getModelPartPosition((Entity)chesedEntity, (String)"core", (FDModel)ChesedEntity.clientModel).y;
        float elapsedTime = ticker.getTime(pticks);
        int timeOffset = 5;
        int animLength = 15;
        float p = Mth.clamp((float)((elapsedTime - (float)timeOffset) / (float)animLength), (float)0.0f, (float)1.0f);
        float size = 5.0f;
        if (elapsedTime > 21.0f) {
            float p2 = Mth.clamp((float)((elapsedTime - 21.0f) / 4.0f), (float)0.0f, (float)1.0f);
            size = (1.0f - p2) * 5.0f;
        }
        if (p == 0.0f) {
            return;
        }
        float easedOut = FDEasings.easeOut((float)p);
        float rotation = easedOut * 180.0f;
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)CHESED_RAY_PREPARE));
        QuadRenderer.start((VertexConsumer)vertexConsumer).color(1.0f, 1.0f, 1.0f, easedOut).translate(0.0f, 0.05f, 0.0f).pose(poseStack).rotationDegrees(rotation).size(size * easedOut).render();
        QuadRenderer.start((VertexConsumer)vertexConsumer).color(1.0f, 1.0f, 1.0f, easedOut).translate(0.0f, 0.05f, 0.0f).pose(poseStack).rotationDegrees(-rotation).size(size * 2.0f * easedOut).render();
        poseStack.pushPose();
        VertexConsumer vertex = multiBufferSource.getBuffer(RenderType.lightning());
        Matrix4f m = poseStack.last().pose();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        Vec3 thisPos = chesedEntity.position();
        Vec3 b = thisPos.subtract(camPos);
        double angle = Math.atan2(b.x, b.z);
        poseStack.mulPose(Axis.YP.rotation((float)Math.PI + (float)angle));
        float width = 0.25f;
        vertex.addVertex(m, 0.0f, 0.0f, 0.0f).setColor(0.3f, 1.0f, 1.0f, p);
        vertex.addVertex(m, 0.0f, height, 0.0f).setColor(0.3f, 1.0f, 1.0f, p);
        vertex.addVertex(m, -width, height, 0.0f).setColor(0.3f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, -width, 0.0f, 0.0f).setColor(0.3f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, width, 0.0f, 0.0f).setColor(0.3f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, width, height, 0.0f).setColor(0.3f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, 0.0f, height, 0.0f).setColor(0.3f, 1.0f, 1.0f, p);
        vertex.addVertex(m, 0.0f, 0.0f, 0.0f).setColor(0.3f, 1.0f, 1.0f, p);
        vertex.addVertex(m, 0.0f, 0.0f, 0.01f).setColor(1.0f, 1.0f, 1.0f, p);
        vertex.addVertex(m, 0.0f, height, 0.01f).setColor(1.0f, 1.0f, 1.0f, p);
        vertex.addVertex(m, -width / 4.0f, height, 0.01f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, -width / 4.0f, 0.0f, 0.01f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, width / 4.0f, 0.0f, 0.01f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, width / 4.0f, height, 0.01f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(m, 0.0f, height, 0.01f).setColor(1.0f, 1.0f, 1.0f, p);
        vertex.addVertex(m, 0.0f, 0.0f, 0.01f).setColor(1.0f, 1.0f, 1.0f, p);
        poseStack.popPose();
    }

    private void renderFinalAttackCracks(ChesedEntity chesedEntity, float yaw, float pticks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        float inTime;
        float offset;
        AnimationSystem system = chesedEntity.getAnimationSystem();
        AnimationTicker ticker = system.getTicker("BOOM");
        if (ticker == null) {
            return;
        }
        float elapsedTime = ticker.getElapsedTime();
        float p = Mth.clamp((float)((elapsedTime - (offset = 149.0f) + pticks) / (inTime = 12.0f)), (float)0.0f, (float)1.0f);
        if (p == 0.0f || elapsedTime > 190.0f) {
            return;
        }
        p = FDEasings.easeInOut((float)p);
        float crackHeightRad = 1.0f;
        int cracksAmount = 80;
        float radius = 35.4f;
        float angle = (float)Math.PI * 2 / (float)cracksAmount;
        float passedAngle = (float)Math.PI * 2 * p;
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.eyes((ResourceLocation)FINAL_ATTACK_CRACKS));
        int id = 0;
        poseStack.pushPose();
        poseStack.translate(0.0, 1.4, 0.0);
        Random random = new Random(234234L);
        float i = 0.0f;
        while (i < passedAngle - angle) {
            poseStack.pushPose();
            Matrix4f matrix4f = poseStack.last().pose();
            poseStack.mulPose(Axis.YP.rotation((float)id * angle + (float)Math.toRadians(-chesedEntity.getYRot() - 90.0f)));
            int texId = 0;
            if (id % 2 == 0) {
                texId = random.nextInt(3) + 1;
            }
            vertexConsumer.addVertex(matrix4f, radius, -crackHeightRad, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv((float)texId * 0.25f + 0.25f, 0.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(matrix4f, radius, crackHeightRad, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv((float)texId * 0.25f + 0.25f, 1.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotation(angle));
            matrix4f = poseStack.last().pose();
            vertexConsumer.addVertex(matrix4f, radius, crackHeightRad, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv((float)texId * 0.25f, 1.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
            vertexConsumer.addVertex(matrix4f, radius, -crackHeightRad, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv((float)texId * 0.25f, 0.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
            poseStack.popPose();
            i += angle;
            ++id;
        }
        poseStack.popPose();
    }

    private void renderRockfallRayEffect(ChesedEntity chesedEntity, float yaw, float pticks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        AnimationSystem system = chesedEntity.getAnimationSystem();
        AnimationTicker ticker = system.getTicker("ROCKFALL");
        if (ticker != null) {
            float elapsedTime = ticker.getTime(pticks);
            float offset = 20.0f;
            float prepareTime = 27.0f;
            float offsetP = Mth.clamp((float)((elapsedTime - offset) / prepareTime), (float)0.0f, (float)1.0f);
            float easedP = FDEasings.easeOut((float)offsetP);
            float rotation = 360.0f * FDEasings.easeOutBack((float)offsetP);
            float alpha = easedP;
            float directionOffset = -1.0f * easedP;
            float sizeMod = 0.0f;
            if (elapsedTime - offset - prepareTime > 0.0f) {
                float awayTime = 7.0f * ticker.getSpeedModifier();
                float offsetP2 = Math.clamp((elapsedTime - offset - prepareTime) / awayTime, 0.0f, 1.0f);
                float easedP2 = FDEasings.easeOut((float)offsetP2);
                alpha = 1.0f - offsetP2;
                directionOffset = 5.0f * easedP2;
                sizeMod = offsetP2 * 2.0f;
            }
            VertexConsumer consumer = multiBufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)CHESED_RAY_PREPARE));
            Vec3 dir = new Vec3(0.0, 1.0, 0.0);
            QuadRenderer.start((VertexConsumer)consumer).color(1.0f, 1.0f, 1.0f, alpha).direction(dir).pose(poseStack).offsetOnDirection(2.0f - directionOffset).translate(0.0f, 1.5f, 0.0f).size(1.5f + sizeMod).rotationDegrees(rotation).render();
            QuadRenderer.start((VertexConsumer)consumer).color(1.0f, 1.0f, 1.0f, alpha).direction(dir).pose(poseStack).offsetOnDirection(3.0f - directionOffset).translate(0.0f, 1.5f, 0.0f).size(0.75f + sizeMod).rotationDegrees(-rotation).render();
            float offset2 = 45.0f;
            float offset2P = FDEasings.easeOut((float)Mth.clamp((float)((elapsedTime - offset2) / 10.0f), (float)0.0f, (float)1.0f));
            if (offset2P > 0.0f && offset2P != 1.0f) {
                QuadRenderer.start((VertexConsumer)consumer).color(1.0f, 1.0f, 1.0f, 1.0f - offset2P).offsetOnDirection(30.0f).size(offset2P * 40.0f).pose(poseStack).render();
                QuadRenderer.start((VertexConsumer)consumer).color(1.0f, 1.0f, 1.0f, 1.0f - offset2P).offsetOnDirection(30.0f).size(offset2P * 20.0f).pose(poseStack).render();
            }
        }
    }

    private void renderRayEffect(ChesedEntity chesedEntity, float yaw, float pticks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        AnimationSystem system = chesedEntity.getAnimationSystem();
        AnimationTicker ticker = system.getTicker("ATTACK");
        if (ticker != null) {
            float elapsedTime = ticker.getTime(pticks);
            float offset = 10.0f;
            float prepareTime = 27.0f;
            float offsetP = Mth.clamp((float)((elapsedTime - offset) / prepareTime), (float)0.0f, (float)1.0f);
            float easedP = FDEasings.easeOut((float)offsetP);
            float rotation = 360.0f * FDEasings.easeOutBack((float)offsetP);
            float alpha = easedP;
            float directionOffset = 0.5f * (1.0f - easedP);
            float sizeMod = 0.0f;
            if (elapsedTime - offset - prepareTime > 0.0f) {
                float awayTime = 7.0f * ticker.getSpeedModifier();
                float offsetP2 = Math.clamp((elapsedTime - offset - prepareTime) / awayTime, 0.0f, 1.0f);
                float easedP2 = FDEasings.easeOut((float)offsetP2);
                alpha = 1.0f - offsetP2;
                directionOffset = 5.0f * easedP2;
                sizeMod = offsetP2 * 2.0f;
            }
            VertexConsumer consumer = multiBufferSource.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)CHESED_RAY_PREPARE));
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).yRot((float)Math.toRadians(-yaw - 90.0f));
            QuadRenderer.start((VertexConsumer)consumer).color(1.0f, 1.0f, 1.0f, alpha).direction(dir).pose(poseStack).offsetOnDirection(2.0f - directionOffset).translate(0.0f, 1.5f, 0.0f).size(1.5f + sizeMod).rotationDegrees(rotation).render();
            QuadRenderer.start((VertexConsumer)consumer).color(1.0f, 1.0f, 1.0f, alpha).direction(dir).pose(poseStack).offsetOnDirection(3.0f - directionOffset).translate(0.0f, 1.5f, 0.0f).size(0.75f + sizeMod).rotationDegrees(-rotation).render();
        }
    }
}

