/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.data_components;

import com.finderfeed.fdbosses.content.items.WeaponCoreItem;
import com.finderfeed.fdbosses.init.BossItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class ItemCoreDataComponent {
    public static final Codec<ItemCoreDataComponent> CODEC = RecordCodecBuilder.create(p -> p.group((App)Codec.STRING.fieldOf("type").forGetter(v -> v.getCoreType().name())).apply((Applicative)p, ItemCoreDataComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemCoreDataComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, v -> v.getCoreType().name(), ItemCoreDataComponent::new);
    private CoreType coreType;

    public ItemCoreDataComponent(CoreType coreType) {
        this.coreType = coreType;
    }

    private ItemCoreDataComponent(String coreType) {
        this.coreType = CoreType.valueOf(coreType);
    }

    public CoreType getCoreType() {
        return this.coreType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemCoreDataComponent that = (ItemCoreDataComponent)o;
        return this.coreType == that.coreType;
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.coreType);
    }

    public static enum CoreType {
        LIGHTNING(BossItems.LIGHTNING_CORE, 0x11FFFF),
        FIRE_AND_ICE(BossItems.FIRE_AND_ICE_CORE, 0xFFAA11);

        private Supplier<WeaponCoreItem> item;
        private int textColor;

        private CoreType(Supplier<WeaponCoreItem> item, int textColor) {
            this.item = item;
            this.textColor = textColor;
        }

        public int getTextColor() {
            return this.textColor;
        }

        public WeaponCoreItem getItem() {
            return this.item.get();
        }
    }
}

