/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block.entity;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.farmingforblockheads.api.MarketPreset;
import net.blay09.mods.farmingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarketBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider<MarketMenu.Data> {
    public MarketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.market.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.farmingforblockheads.market");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new MarketMenu(windowId, playerInventory, this.worldPosition, MarketBlockEntity.getPresetFilter(), MarketBlockEntity.getCategoryFilter());
    }

    @NotNull
    private static Set<ResourceLocation> getCategoryFilter() {
        return Set.of();
    }

    @NotNull
    private static Set<ResourceLocation> getPresetFilter() {
        return MarketPresetRegistry.INSTANCE.getEntries().stream().filter(it -> ((MarketPreset)it.getValue()).enabledByDefault()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public MarketMenu.Data getScreenOpeningData(ServerPlayer serverPlayer) {
        return new MarketMenu.Data(this.worldPosition, MarketBlockEntity.getPresetFilter(), MarketBlockEntity.getCategoryFilter());
    }

    public StreamCodec<RegistryFriendlyByteBuf, MarketMenu.Data> getScreenStreamCodec() {
        return MarketMenu.STREAM_CODEC;
    }
}

