/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.balm.api.block.CustomFarmBlock;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.item.FertilizerItem;
import net.blay09.mods.farmingforblockheads.mixin.FarmBlockAccessor;
import net.blay09.mods.farmingforblockheads.tag.ModBlockTags;
import net.blay09.mods.farmingforblockheads.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FertilizedFarmlandBlock
extends FarmBlock
implements CustomFarmBlock {
    public static final MapCodec<FarmBlock> CODEC = FertilizedFarmlandBlock.simpleCodec(FertilizedFarmlandBlock::new);

    public FertilizedFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.GRAVEL).strength(0.6f).randomTicks());
    }

    public boolean canSustainPlant(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction, Block block) {
        return true;
    }

    public boolean isFertile(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return (Integer)state.getValue((Property)MOISTURE) > 0;
    }

    public float getRegressionChance() {
        return (float)FarmingForBlockheadsConfig.getActive().fertilizerRegressionChance;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!state.is(ModBlockTags.STABLE_FARMLAND)) {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.getValue((Property)MOISTURE);
        if (!FarmBlockAccessor.callIsNearWater((LevelReader)level, pos) && !level.isRainingAt(pos.above())) {
            if (moisture > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!FarmBlockAccessor.callShouldMaintainFarmland((BlockGetter)level, pos) && state.is(ModBlockTags.STABLE_FARMLAND)) {
                FertilizedFarmlandBlock.turnToDirt(null, (BlockState)state, (Level)level, (BlockPos)pos);
            }
        } else if (moisture < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (itemStack.is(ModItemTags.HEALTHY_FARMLAND)) {
            tooltip.add(FertilizerItem.FertilizerType.HEALTHY.getTooltip());
        }
        if (itemStack.is(ModItemTags.RICH_FARMLAND)) {
            tooltip.add(FertilizerItem.FertilizerType.RICH.getTooltip());
        }
        if (itemStack.is(ModItemTags.STABLE_FARMLAND)) {
            tooltip.add(FertilizerItem.FertilizerType.STABLE.getTooltip());
        }
    }

    public MapCodec<FarmBlock> codec() {
        return CODEC;
    }
}

