/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.events.screen.ScreenMouseScrollEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnMouseScrolledListener
extends AbstractListener {
    @Nullable
    private Double lastScrollDeltaY;

    public OnMouseScrolledListener() {
        super("mouse_scrolled");
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @EventListener
    public void onMouseScrolled(@NotNull ScreenMouseScrollEvent.Pre event) {
        this.lastScrollDeltaY = event.getScrollDeltaY();
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("scroll_delta_y", () -> this.formatValue(this.lastScrollDeltaY)));
    }

    private String formatValue(@Nullable Double value) {
        if (value == null) {
            return "ERROR";
        }
        return Double.toString(value);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_mouse_scrolled");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_mouse_scrolled.desc", new String[0]));
    }
}

