/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.listener.ListenerInstance;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListenerHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final File LISTENERS_FILE = new File(FancyMenu.MOD_DIR, "listener_instances.txt");
    private static final Map<String, ListenerInstance> INSTANCES = new HashMap<String, ListenerInstance>();
    public static boolean canRegisterListeners = true;
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            ListenerHandler.readFromFile();
        }
        initialized = true;
        canRegisterListeners = false;
    }

    public static void addInstance(@NotNull ListenerInstance instance) {
        ListenerHandler.assertInitialized();
        INSTANCES.put(instance.instanceIdentifier, instance);
        instance.registerSelfToParent();
        ListenerHandler.writeToFile();
    }

    public static void removeInstance(@NotNull String identifier) {
        ListenerHandler.assertInitialized();
        ListenerInstance instance = INSTANCES.get(identifier);
        if (instance != null) {
            instance.parent.unregisterInstance(instance);
        }
        INSTANCES.remove(identifier);
        ListenerHandler.writeToFile();
    }

    public static void syncChanges() {
        ListenerHandler.writeToFile();
    }

    @Nullable
    public static ListenerInstance getInstance(@NotNull String identifier) {
        ListenerHandler.assertInitialized();
        return INSTANCES.get(identifier);
    }

    @NotNull
    public static List<ListenerInstance> getInstances() {
        ListenerHandler.assertInitialized();
        return new ArrayList<ListenerInstance>(INSTANCES.values());
    }

    private static void writeToFile() {
        ListenerHandler.assertInitialized();
        try {
            PropertyContainerSet instances = new PropertyContainerSet("listener_instances");
            INSTANCES.forEach((s, instance) -> instances.putContainer(instance.serialize()));
            PropertiesParser.serializeSetToFile(instances, LISTENERS_FILE.getAbsolutePath());
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to serialize listener instances to file!", (Throwable)ex);
        }
    }

    private static void readFromFile() {
        INSTANCES.clear();
        try {
            if (!LISTENERS_FILE.isFile()) {
                return;
            }
            PropertyContainerSet instances = Objects.requireNonNull(PropertiesParser.deserializeSetFromFile(LISTENERS_FILE.getAbsolutePath()), "Parser returned NULL as PropertyContainerSet!");
            instances.getContainers().forEach(propertyContainer -> {
                ListenerInstance instance = ListenerInstance.deserialize(propertyContainer);
                if (instance != null) {
                    INSTANCES.put(instance.instanceIdentifier, instance);
                    instance.registerSelfToParent();
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize listener instances from file!", (Throwable)ex);
        }
    }

    public static void assertInitialized() {
        if (!initialized) {
            throw new RuntimeException("[FANCYMENU] Tried to access ListenerHandler too early! Not ready yet!");
        }
    }
}

