/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.living.entityjs;

import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJSCustom;
import net.liopyu.entityjs.util.EntityJSUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WrappedAnimatableEntity
extends LivingEntity
implements IAnimatableJSCustom {
    private final LivingEntity originalEntity;
    private final CustomEntityJSBuilder builder;
    private final AnimatableInstanceCache animatableCache;

    public WrappedAnimatableEntity(LivingEntity originalEntity, CustomEntityJSBuilder builder) {
        super(originalEntity.getType(), originalEntity.level());
        this.originalEntity = originalEntity;
        this.builder = builder;
        this.animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    }

    public int getId() {
        return this.originalEntity.getId();
    }

    public LivingEntity getOriginalEntity() {
        return this.originalEntity;
    }

    public int getTickCount() {
        return this.getOriginalEntity().tickCount;
    }

    public HumanoidArm getMainArm() {
        return this.originalEntity.getMainArm();
    }

    @Override
    public CustomEntityJSBuilder getBuilder() {
        return this.builder != null ? this.builder : (CustomEntityJSBuilder)((Object)EntityJSUtils.getEntityBuilder(this.getType()));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.originalEntity.getArmorSlots();
    }

    public Iterable<ItemStack> getHandSlots() {
        return this.originalEntity.getHandSlots();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return this.originalEntity.getItemBySlot(slot);
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        this.originalEntity.setItemSlot(slot, stack);
    }
}

