/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile;

import java.util.Map;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionInfo;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;

public class ChunkBuildOutput {
    public final RenderSection render;
    public final BuiltSectionInfo info;
    public final Map<TerrainRenderPass, BuiltSectionMeshParts> meshes;
    public final int buildTime;
    private boolean partialUpload;

    public ChunkBuildOutput(RenderSection render, BuiltSectionInfo info, Map<TerrainRenderPass, BuiltSectionMeshParts> meshes, int buildTime) {
        this.render = render;
        this.info = info;
        this.meshes = meshes;
        this.buildTime = buildTime;
    }

    public BuiltSectionMeshParts getMesh(TerrainRenderPass pass) {
        return this.meshes.get(pass);
    }

    public void delete() {
        for (BuiltSectionMeshParts data : this.meshes.values()) {
            if (data.getVertexData() != null) {
                data.getVertexData().free();
            }
            if (data.getIndexData() == null) continue;
            data.getIndexData().free();
        }
    }

    public boolean isIndexOnlyUpload() {
        return this.partialUpload;
    }

    public void setIndexOnlyUpload(boolean flag) {
        this.partialUpload = flag;
    }
}

