/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.render.immediate.buffer_builder.sorting;

import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={MeshData.class})
public abstract class MeshDataMixin {
    @Overwrite
    private static Vector3f[] unpackQuadCentroids(ByteBuffer buffer, int vertices, VertexFormat format) {
        int vertexStride = format.getVertexSize();
        int primitiveCount = vertices / 4;
        Vector3f[] centers = new Vector3f[primitiveCount];
        int renderedBufferPointer = buffer.position();
        for (int index = 0; index < primitiveCount; ++index) {
            long v1 = MemoryUtil.memAddress((ByteBuffer)buffer, (int)(renderedBufferPointer + (index * 4 + 0) * vertexStride));
            long v2 = MemoryUtil.memAddress((ByteBuffer)buffer, (int)(renderedBufferPointer + (index * 4 + 2) * vertexStride));
            float x1 = MemoryUtil.memGetFloat((long)(v1 + 0L));
            float y1 = MemoryUtil.memGetFloat((long)(v1 + 4L));
            float z1 = MemoryUtil.memGetFloat((long)(v1 + 8L));
            float x2 = MemoryUtil.memGetFloat((long)(v2 + 0L));
            float y2 = MemoryUtil.memGetFloat((long)(v2 + 4L));
            float z2 = MemoryUtil.memGetFloat((long)(v2 + 8L));
            centers[index] = new Vector3f((x1 + x2) * 0.5f, (y1 + y2) * 0.5f, (z1 + z2) * 0.5f);
        }
        return centers;
    }
}

