/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.embeddedt.embeddium.impl.gl.shader.GlShader;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;
import org.embeddedt.embeddium.impl.gl.shader.ShaderParser;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;

public class ShaderLoader {
    public static GlShader loadShader(ShaderType type, ResourceLocation name, ShaderConstants constants) {
        return new GlShader(type, name, ShaderParser.parseShader(ShaderLoader.getShaderSource(name), constants));
    }

    public static String getShaderSource(ResourceLocation name) {
        String string;
        block9: {
            String path = String.format("assets/%s/shaders/%s", name.getNamespace(), name.getPath());
            InputStream in = ShaderLoader.class.getClassLoader().getResourceAsStream(path);
            try {
                if (in == null) {
                    throw new RuntimeException("Shader not found: " + path);
                }
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read shader source for " + path, e);
                }
            }
            in.close();
        }
        return string;
    }
}

