/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue.styles;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.dialogue.DialogueStyle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;

public class DialogueStyleManager {
    public static HashMap<ResourceLocation, DialogueStyle> styles = new HashMap();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void init() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        ResourceManager resourceManager = mc.getResourceManager();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
            resourceManager2.registerReloadListener(DialogueStyleManager::reload);
        }
    }

    public static CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.listResources("databank/dialogue/styles", name -> name.toString().endsWith(".json")), backgroundExecutor).thenApply(resources -> {
            HashMap<ResourceLocation, CompletableFuture<DialogueStyle>> tasks = new HashMap<ResourceLocation, CompletableFuture<DialogueStyle>>();
            for (ResourceLocation i : resources.keySet()) {
                tasks.put(i, CompletableFuture.supplyAsync(() -> {
                    JsonObject json;
                    try {
                        Resource resource = resourceManager.getResourceOrThrow(i);
                        InputStream stream = resource.open();
                        json = (JsonObject)GsonHelper.fromJson((Gson)GSON, (String)IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset()), JsonObject.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return (DialogueStyle)DialogueStyle.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
                }));
            }
            return tasks;
        })).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAccept(tasks -> {
            HashMap<ResourceLocation, DialogueStyle> styles = new HashMap<ResourceLocation, DialogueStyle>();
            for (Map.Entry i : tasks.entrySet()) {
                String path = ((ResourceLocation)i.getKey()).getPath().replaceFirst("databank/dialogue/styles/", "");
                path = path.substring(0, path.length() - 5);
                styles.put(((ResourceLocation)i.getKey()).withPath(path), (DialogueStyle)((CompletableFuture)i.getValue()).join());
            }
            styles = styles;
            Databank.LOGGER.info("[DATABANK] Loaded Databank Dialogue Styles");
        });
    }
}

