/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue.styles;

import com.cmdpro.databank.dialogue.DialogueChoice;
import com.cmdpro.databank.dialogue.DialogueInstance;
import com.cmdpro.databank.dialogue.DialogueStyle;
import com.cmdpro.databank.rendering.NineSliceSprite;
import com.cmdpro.databank.rendering.SpriteData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.FormattedBidiReorder;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class BasicDialogueStyle
extends DialogueStyle {
    public NineSliceSprite textBorder;
    public NineSliceSprite choiceBorder;
    public NineSliceSprite choiceHoverBorder;
    public NineSliceSprite nameBorder;
    public SpriteData portraitBorder;
    public NineSliceSprite scrollBorder;
    public SpriteData scrollPoint;
    public SpriteData scrollPointHovered;
    public Holder<SoundEvent> clickSound;
    public int charactersPerTick;
    public static final MapCodec<BasicDialogueStyle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NineSliceSprite.CODEC.fieldOf("textBorder").forGetter(obj -> obj.textBorder), (App)NineSliceSprite.CODEC.fieldOf("choiceBorder").forGetter(obj -> obj.choiceBorder), (App)NineSliceSprite.CODEC.fieldOf("choiceHoverBorder").forGetter(obj -> obj.choiceHoverBorder), (App)NineSliceSprite.CODEC.fieldOf("nameBorder").forGetter(obj -> obj.nameBorder), (App)SpriteData.CODEC.fieldOf("portraitBorder").forGetter(obj -> obj.portraitBorder), (App)NineSliceSprite.CODEC.fieldOf("scrollBorder").forGetter(obj -> obj.scrollBorder), (App)SpriteData.CODEC.fieldOf("scrollPoint").forGetter(obj -> obj.scrollPoint), (App)SpriteData.CODEC.fieldOf("scrollPointHovered").forGetter(obj -> obj.scrollPointHovered), (App)SoundEvent.CODEC.optionalFieldOf("clickSound", (Object)SoundEvents.UI_BUTTON_CLICK).forGetter(obj -> obj.clickSound), (App)Codec.INT.optionalFieldOf("charactersPerTick", (Object)1).forGetter(obj -> obj.charactersPerTick)).apply((Applicative)instance, BasicDialogueStyle::new));
    double scroll = 0.0;
    boolean scrolling = false;

    public BasicDialogueStyle(NineSliceSprite textBorder, NineSliceSprite choiceBorder, NineSliceSprite choiceHoverBorder, NineSliceSprite nameBorder, SpriteData portraitBorder, NineSliceSprite scrollBorder, SpriteData scrollPoint, SpriteData scrollPointHovered, Holder<SoundEvent> clickSound, int charactersPerTick) {
        this.textBorder = textBorder;
        this.choiceHoverBorder = choiceHoverBorder;
        this.choiceBorder = choiceBorder;
        this.nameBorder = nameBorder;
        this.portraitBorder = portraitBorder;
        this.scrollBorder = scrollBorder;
        this.scrollPoint = scrollPoint;
        this.scrollPointHovered = scrollPointHovered;
        this.clickSound = clickSound;
        this.charactersPerTick = charactersPerTick;
    }

    @Override
    public MapCodec<? extends DialogueStyle> getCodec() {
        return CODEC;
    }

    @Override
    public boolean mouseClick(DialogueInstance instance, double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        for (int i = 0; i < instance.entry.choices.size(); ++i) {
            if (!this.isHovering(instance, i, mouseX, mouseY)) continue;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.runChoice(i);
            return true;
        }
        if (this.isHoveringScroll(instance, mouseX, mouseY)) {
            this.scrolling = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseRelease(DialogueInstance instance, double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        this.scrolling = false;
        return super.mouseRelease(instance, mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDrag(DialogueInstance instance, double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return false;
        }
        if (this.scrolling) {
            double y = mouseY + dragY - (double)this.scrollPoint.height() / 2.0;
            double progress = y - (double)this.getScrollPointStartY();
            progress = Math.clamp(progress, 0.0, (double)this.getScrollHeight());
            this.scroll = progress /= (double)this.getScrollHeight();
            return true;
        }
        return false;
    }

    @Override
    public void changeEntry(DialogueInstance instance, String from, String to) {
        super.changeEntry(instance, from, to);
        this.scroll = 0.0;
        this.scrolling = false;
    }

    public boolean isHovering(DialogueInstance instance, int index, double mouseX, double mouseY) {
        DialogueChoice choice = instance.entry.choices.get(index);
        int choiceX = this.getChoiceX(choice, index);
        int choiceY = this.getChoiceY(choice, index);
        int width = 128;
        int height = 8;
        return mouseX >= (double)(choiceX -= this.choiceBorder.left() - this.choiceBorder.defaultInset()) && mouseX <= (double)(choiceX + (width += this.choiceBorder.getHorizontalInset())) && mouseY >= (double)(choiceY -= this.choiceBorder.top() - this.choiceBorder.defaultInset()) && mouseY <= (double)(choiceY + (height += this.choiceBorder.getVerticalInset()));
    }

    public int getScrollX() {
        int dialogueWidth = this.getDialogueBoxWidth();
        int x = this.getX();
        return x + dialogueWidth - (2 + this.getScrollBorder().width());
    }

    public int getScrollY() {
        int y = this.getY();
        return y + 2;
    }

    public int getScrollPointX() {
        int x = this.getScrollX();
        return x + 1;
    }

    public int getScrollPointStartY() {
        return this.getScrollY() + 1;
    }

    public int getScrollPointY() {
        int y = this.getScrollPointStartY();
        return y += (int)((double)(this.getScrollHeight() - 2) * this.scroll);
    }

    public int getScrollHeight() {
        return this.getDialogueBoxHeight() - 4 - this.scrollPoint.height();
    }

    public boolean scrollEnabled(DialogueInstance instance) {
        Font font = this.getFont();
        List lines = font.getSplitter().splitLines((FormattedText)instance.entry.text, this.getDialogueBoxWidth() - 48 - 8, Style.EMPTY);
        Objects.requireNonNull(font);
        int neededHeight = 9 * lines.size();
        return neededHeight >= this.getDialogueBoxHeight() - 10;
    }

    public boolean isHoveringScroll(DialogueInstance instance, double mouseX, double mouseY) {
        if (!this.scrollEnabled(instance)) {
            return false;
        }
        int scrollX = this.getScrollPointX();
        int scrollY = this.getScrollPointY();
        int width = this.scrollPoint.width();
        int height = this.scrollPoint.height();
        return mouseX >= (double)scrollX && mouseX <= (double)(scrollX + width) && mouseY >= (double)scrollY && mouseY <= (double)(scrollY + height);
    }

    @Override
    public void tick(DialogueInstance instance, double lastTicksPassed, double ticksPassed) {
        super.tick(instance, lastTicksPassed, ticksPassed);
        String str = instance.entry.text.getString().replace("\n", "");
        int strLength = str.length() - 1;
        int charactersShown = (int)Math.floor((double)this.charactersPerTick * ticksPassed);
        int lastCharactersShown = (int)Math.floor((double)this.charactersPerTick * lastTicksPassed);
        if (charactersShown > strLength) {
            charactersShown = strLength;
        }
        if (lastCharactersShown > strLength) {
            lastCharactersShown = strLength;
        }
        boolean play = false;
        for (int i = lastCharactersShown + 1; i <= charactersShown; ++i) {
            char character = str.charAt(i);
            if (character == ' ') continue;
            play = true;
        }
        if (charactersShown != lastCharactersShown) {
            Font font = this.getFont();
            List lines = font.getSplitter().splitLines((FormattedText)instance.entry.text, this.getDialogueBoxWidth() - 48 - 8, Style.EMPTY);
            int characterStart = 0;
            int pixelsPassed = 0;
            int fullPixels = 0;
            for (FormattedText i : lines) {
                if (characterStart < charactersShown) {
                    Objects.requireNonNull(font);
                    pixelsPassed += 9;
                }
                Objects.requireNonNull(font);
                fullPixels += 9;
                characterStart += i.getString().length();
            }
            int n = this.getDialogueBoxHeight();
            Objects.requireNonNull(font);
            int sub = n - 9;
            int pixelsNeeded = pixelsPassed - sub;
            if (pixelsNeeded < 0) {
                pixelsNeeded = 0;
            }
            if ((fullPixels -= sub) < 0) {
                fullPixels = 0;
            }
            this.scroll = Math.clamp((double)pixelsNeeded / (double)fullPixels, 0.0, 1.0);
            if (play) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(instance.entry.getSpeaker().talkSound, (float)1.0f));
            }
        }
    }

    private Component cutComponent(FormattedText component, int end) {
        MutableComponent newComponent = Component.empty();
        AtomicInteger characters = new AtomicInteger(0);
        component.visit((style, string) -> {
            if (characters.get() <= end) {
                if (characters.get() + string.length() > end) {
                    int strEnd = end - characters.get();
                    newComponent.append((Component)Component.literal((String)string.substring(0, strEnd)).setStyle(style));
                } else {
                    newComponent.append((Component)Component.literal((String)string).setStyle(style));
                }
            }
            characters.addAndGet(string.length());
            return Optional.empty();
        }, Style.EMPTY);
        return newComponent;
    }

    @Override
    public void render(DialogueInstance instance, GuiGraphics graphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        NineSliceSprite textBorder = this.getTextBorder();
        NineSliceSprite choiceBorder = this.getChoiceBorder();
        NineSliceSprite choiceHoverBorder = this.getChoiceHoverBorder();
        NineSliceSprite nameBorder = this.getNameBorder();
        NineSliceSprite scrollBorder = this.getScrollBorder();
        SpriteData portraitBorder = this.getPortraitBorder();
        SpriteData scrollPoint = this.getScrollPoint();
        SpriteData scrollPointHovered = this.getScrollPointHovered();
        int charactersShown = (int)Math.floor((double)this.charactersPerTick * instance.ticksOnEntry);
        int dialogueWidth = this.getDialogueBoxWidth();
        int dialogueHeight = this.getDialogueBoxHeight();
        int x = this.getX();
        int y = this.getY();
        textBorder.blit(graphics, x, y, dialogueWidth, dialogueHeight);
        int centerY = y + dialogueHeight / 2;
        Font font = this.getFont();
        Component text = instance.entry.text;
        List lines = font.getSplitter().splitLines((FormattedText)text, dialogueWidth - 48 - 8, Style.EMPTY);
        int padding = 0;
        float f = lines.size();
        Objects.requireNonNull(font);
        int lineY = centerY - (int)(f * (9.0f / 2.0f + (float)padding));
        if (lineY < y + 6) {
            lineY = y + 6;
        }
        Objects.requireNonNull(font);
        int neededHeight = 9 * lines.size();
        double scroll = (double)(neededHeight -= dialogueHeight - 10) * this.scroll;
        graphics.enableScissor(x, y + 6, x + dialogueWidth, y + dialogueHeight - 4);
        lineY -= (int)scroll;
        int characterStart = 0;
        for (FormattedText i : lines) {
            if (characterStart > charactersShown) break;
            int end = charactersShown - characterStart;
            Component component = this.cutComponent(i, end);
            FormattedCharSequence formattedCharSequence = FormattedBidiReorder.reorder((FormattedText)component, (boolean)Language.getInstance().isDefaultRightToLeft());
            graphics.drawString(font, formattedCharSequence, x + 48, lineY, -1);
            characterStart += i.getString().length();
            Objects.requireNonNull(font);
            lineY += 9 + padding;
        }
        graphics.disableScissor();
        int portraitX = x + 8;
        int portraitY = y + 8;
        graphics.blit(portraitBorder.texture(), portraitX - 4, portraitY - 4, portraitBorder.u(), portraitBorder.v(), 40, 40);
        graphics.blit(instance.entry.getSpeaker().portrait, portraitX, portraitY, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        int nameWidth = Math.clamp((long)font.width((FormattedText)instance.entry.getSpeaker().name), 64, Integer.MAX_VALUE);
        nameBorder.blit(graphics, portraitX + 16 - nameWidth / 2, y - 17, nameWidth, 8);
        graphics.drawCenteredString(font, instance.entry.getSpeaker().name, portraitX + 16, y - 17, -1);
        for (int i = 0; i < instance.entry.choices.size(); ++i) {
            DialogueChoice choice = instance.entry.choices.get(i);
            int choiceX = this.getChoiceX(choice, i);
            int choiceY = this.getChoiceY(choice, i);
            (this.isHovering(instance, i, mouseX, mouseY) ? choiceHoverBorder : choiceBorder).blit(graphics, choiceX, choiceY, 128, 8);
            graphics.drawCenteredString(font, choice.text, choiceX + 64, choiceY, -1);
        }
        if (this.scrollEnabled(instance)) {
            scrollBorder.blit(graphics, this.getScrollX(), this.getScrollY() + scrollBorder.top(), scrollBorder.width(), this.getScrollHeight() + 1 - scrollBorder.bottom());
            (this.isHoveringScroll(instance, mouseX, mouseY) || this.scrolling ? scrollPointHovered : scrollPoint).blit(graphics, this.getScrollPointX(), this.getScrollPointY());
        } else {
            this.scroll = 0.0;
        }
        graphics.flush();
        RenderSystem.disableBlend();
    }

    public int getDialogueBoxWidth() {
        return 320;
    }

    public int getDialogueBoxHeight() {
        return 48;
    }

    public int getChoiceX(DialogueChoice choice, int index) {
        return this.getX() + this.getDialogueBoxWidth() - 136;
    }

    public int getChoiceY(DialogueChoice choice, int index) {
        return this.getY() - 18 * (index + 1);
    }

    public int getX() {
        return this.getGuiWidth() / 2 - this.getDialogueBoxWidth() / 2;
    }

    public int getY() {
        return this.getGuiHeight() - 58;
    }

    public int getGuiWidth() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth();
    }

    public int getGuiHeight() {
        return Minecraft.getInstance().getWindow().getGuiScaledHeight();
    }

    public NineSliceSprite getTextBorder() {
        return this.textBorder;
    }

    public NineSliceSprite getChoiceBorder() {
        return this.choiceBorder;
    }

    public NineSliceSprite getChoiceHoverBorder() {
        return this.choiceHoverBorder;
    }

    public NineSliceSprite getNameBorder() {
        return this.nameBorder;
    }

    public SpriteData getPortraitBorder() {
        return this.portraitBorder;
    }

    public NineSliceSprite getScrollBorder() {
        return this.scrollBorder;
    }

    public SpriteData getScrollPoint() {
        return this.scrollPoint;
    }

    public SpriteData getScrollPointHovered() {
        return this.scrollPointHovered;
    }

    public Font getFont() {
        return Minecraft.getInstance().font;
    }
}

