/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.dialogue.DialogueTree;
import com.cmdpro.databank.music.MusicSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class DialogueTreeManager
extends SimpleJsonResourceReloadListener {
    public static HashMap<ResourceLocation, DialogueTree> trees = new HashMap();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static DialogueTreeManager instance;
    public static MusicSerializer serializer;

    protected DialogueTreeManager() {
        super(GSON, "databank/dialogue/trees");
    }

    public static DialogueTreeManager getOrCreateInstance() {
        if (instance == null) {
            instance = new DialogueTreeManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        trees = new HashMap();
        Databank.LOGGER.info("[DATABANK] Adding Databank Dialogue Trees");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                JsonObject obj = i.getValue().getAsJsonObject();
                DialogueTree tree = (DialogueTree)DialogueTree.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow();
                trees.put(i.getKey(), tree);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Databank.LOGGER.error("[DATABANK ERROR] Parsing error loading dialogue tree type {}", (Object)location, (Object)e);
            }
        }
        Databank.LOGGER.info("[DATABANK] Loaded {} Dialogue Trees", (Object)trees.size());
    }

    static {
        serializer = new MusicSerializer();
    }
}

