/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue;

import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.dialogue.DialogueChoiceAction;
import com.cmdpro.databank.dialogue.DialogueEntry;
import com.cmdpro.databank.dialogue.DialogueInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class DialogueChoice {
    public static final Codec<DialogueChoice> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ComponentSerialization.CODEC.fieldOf("text").forGetter(obj -> obj.text), (App)DialogueChoiceAction.CODEC.listOf().fieldOf("actions").forGetter(obj -> obj.actions)).apply((Applicative)builder, DialogueChoice::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DialogueChoice> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
        ComponentSerialization.STREAM_CODEC.encode(buf, (Object)obj.text);
        buf.writeCollection(obj.actions, (buf2, obj2) -> {
            buf.writeResourceLocation(DatabankRegistries.DIALOGUE_CHOICE_ACTION_REGISTRY.getKey((Object)obj2.getCodecs()));
            obj2.getStreamCodec().encode((Object)((RegistryFriendlyByteBuf)buf2), obj2);
        });
    }, buf -> {
        Component text = (Component)ComponentSerialization.STREAM_CODEC.decode(buf);
        List actions = buf.readList(buf2 -> {
            ResourceLocation dialogueActionType = buf.readResourceLocation();
            return (DialogueChoiceAction)((DialogueChoiceAction.Codecs)DatabankRegistries.DIALOGUE_CHOICE_ACTION_REGISTRY.get(dialogueActionType)).streamCodec().decode((Object)((RegistryFriendlyByteBuf)buf2));
        });
        return new DialogueChoice(text, actions);
    });
    public DialogueEntry entry;
    public Component text;
    public List<DialogueChoiceAction> actions;

    public DialogueChoice(Component text, List<DialogueChoiceAction> actions) {
        this.text = text;
        this.actions = actions;
    }

    public void onClick(Player player, DialogueInstance instance, DialogueChoice choice) {
        for (DialogueChoiceAction i : this.actions) {
            i.onClick(player, instance, choice);
        }
    }
}

