/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.custommachineryars;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.data.DominionWandData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import es.degrassi.custommachineryars.Registration;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Mod(value="custommachineryars")
public class CustommachineryArs {
    public static final String MODID = "custommachineryars";

    public CustommachineryArs(IEventBus MOD_BUS) {
        this.registryInit(MOD_BUS);
        MOD_BUS.addListener(this::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(this::handleWandClick);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(CapabilityRegistry.SOURCE_CAPABILITY, (BlockEntityType)fr.frinn.custommachinery.common.init.Registration.CUSTOM_MACHINE_TILE.get(), (be, side) -> be.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).orElse(null));
    }

    private void registryInit(IEventBus bus) {
        Registration.GUI_ELEMENTS.register(bus);
        Registration.MACHINE_COMPONENTS.register(bus);
        Registration.REQUIREMENTS.register(bus);
        Registration.DATAS.register(bus);
    }

    private void handleWandClick(PlayerInteractEvent.RightClickBlock event) {
        Item item;
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && !(player = (ServerPlayer)player2).isShiftKeyDown() && (item = player.getItemInHand(event.getHand()).getItem()) instanceof DominionWand) {
            DominionWand wand = (DominionWand)item;
            item = player.level().getBlockEntity(event.getPos());
            if (item instanceof CustomMachineTile) {
                IWandable wandable;
                BlockEntity blockEntity;
                CustomMachineTile tile = (CustomMachineTile)item;
                if (!tile.getComponentManager().hasComponent(Registration.SOURCE_MACHINE_COMPONENT.get())) {
                    return;
                }
                ItemStack stack = player.getItemInHand(event.getHand());
                DominionWandData data = (DominionWandData)stack.getOrDefault((DataComponentType)DataComponentRegistry.DOMINION_WAND.get(), (Object)new DominionWandData());
                if (!data.hasStoredData()) {
                    if ((data = data.storePos(new GlobalPos(event.getLevel().dimension(), event.getPos().immutable()))).strict()) {
                        data = data.setFace(event.getFace());
                    }
                    stack.set((DataComponentType)DataComponentRegistry.DOMINION_WAND.get(), (Object)data);
                    PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_set"));
                    event.setCancellationResult(InteractionResult.CONSUME);
                    event.setCanceled(true);
                    return;
                }
                if (data.storedPos().isPresent() && (blockEntity = player.getCommandSenderWorld().getBlockEntity(((GlobalPos)data.storedPos().get()).pos())) instanceof IWandable) {
                    wandable = (IWandable)blockEntity;
                    wandable.onFirstConnection((GlobalPos)data.storedPos().get(), event.getFace(), (LivingEntity)event.getLevel().getEntity(data.storedEntityId()), (Player)player);
                }
                if (tile instanceof IWandable) {
                    wandable = (IWandable)tile;
                    wandable.onLastConnection((GlobalPos)data.storedPos().get(), event.getFace(), (LivingEntity)event.getLevel().getEntity(data.storedEntityId()), (Player)player);
                    tile.getComponentManager().markDirty();
                }
                if (data.storedEntityId() != -1 && (blockEntity = event.getLevel().getEntity(data.storedEntityId())) instanceof IWandable) {
                    wandable = (IWandable)blockEntity;
                    wandable.onLastConnection(new GlobalPos(event.getLevel().dimension(), event.getPos().immutable()), event.getFace(), null, (Player)player);
                }
                wand.clear(stack, (Player)player);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
        }
    }
}

