/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.dimension;

import dev.compactmods.machines.api.dimension.CompactDimension;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class WorldBorderFixer {
    public static void registerEvents() {
        NeoForge.EVENT_BUS.addListener(WorldBorderFixer::onWorldLoaded);
        NeoForge.EVENT_BUS.addListener(WorldBorderFixer::onPlayerLogin);
        NeoForge.EVENT_BUS.addListener(WorldBorderFixer::onPlayerDimChange);
    }

    private static void onWorldLoaded(LevelEvent.Load evt) {
        ServerLevel compactDim;
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof ServerLevel && (compactDim = (ServerLevel)levelAccessor).dimension().equals(CompactDimension.LEVEL_KEY)) {
            WorldBorderFixer.sendWorldBorderListenerOverrides(compactDim.getServer(), compactDim);
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        ServerPlayer sp;
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer && CompactDimension.isLevelCompact((Level)(sp = (ServerPlayer)player).level())) {
            WorldBorderFixer.sendClientWorldBorderFix(sp);
        }
    }

    private static void onPlayerDimChange(PlayerEvent.PlayerChangedDimensionEvent evt) {
        Player player;
        if (evt.getTo().equals(CompactDimension.LEVEL_KEY) && (player = evt.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            WorldBorderFixer.sendClientWorldBorderFix(sp);
        }
    }

    private static void sendWorldBorderListenerOverrides(MinecraftServer serv, ServerLevel compactDim) {
        WorldBorder owBorder = serv.overworld().getWorldBorder();
        WorldBorder cwBorder = compactDim.getWorldBorder();
        Set listeners = owBorder.listeners.stream().filter(border -> border instanceof BorderChangeListener.DelegateBorderChangeListener).map(BorderChangeListener.DelegateBorderChangeListener.class::cast).filter(list -> list.worldBorder == cwBorder).collect(Collectors.toSet());
        for (BorderChangeListener.DelegateBorderChangeListener listener : listeners) {
            owBorder.removeListener((BorderChangeListener)listener);
        }
        cwBorder.setCenter(0.0, 0.0);
        cwBorder.setSize(5.9999968E7);
        serv.getPlayerList().broadcastAll((Packet)new ClientboundSetBorderSizePacket(cwBorder), compactDim.dimension());
    }

    private static void sendClientWorldBorderFix(ServerPlayer player) {
        player.connection.send((Packet)new ClientboundInitializeBorderPacket(new WorldBorder()));
    }
}

