/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.data.AttachmentDataFileFactoryInput;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import dev.compactmods.machines.data.SafeAttachmentsCodec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.attachment.AttachmentHolder;

public abstract class AttachmentBasedDataFile<T extends AttachmentHolder, TAdditionalData>
extends AttachmentHolder
implements CMDataFile,
CodecHolder<T> {
    protected final Codec<T> codec;
    private final MapCodec<TAdditionalData> additionalDataCodec;
    private final Function<AttachmentDataFileFactoryInput<TAdditionalData>, T> factory;
    private final Method deserializeAttachments = ObfuscationReflectionHelper.findMethod(AttachmentHolder.class, (String)"deserializeAttachments", (Class[])new Class[]{HolderLookup.Provider.class, CompoundTag.class});

    protected AttachmentBasedDataFile(MinecraftServer server, MapCodec<TAdditionalData> additionalDataCodec, Function<AttachmentDataFileFactoryInput<TAdditionalData>, T> factory) {
        this.additionalDataCodec = additionalDataCodec;
        this.factory = factory;
        this.codec = this.makeCodec(server);
    }

    protected abstract TAdditionalData dataSupplier(T var1);

    public Codec<T> makeCodec(MinecraftServer server) {
        return RecordCodecBuilder.create(i -> i.group((App)CompoundTag.CODEC.fieldOf("attachments").forGetter(inst -> SafeAttachmentsCodec.safeSerialize(inst, server)), (App)this.additionalDataCodec.forGetter(this::dataSupplier)).apply((Applicative)i, (ct, data) -> {
            AttachmentHolder template = (AttachmentHolder)this.factory.apply(new AttachmentDataFileFactoryInput<Object>(server, (CompoundTag)ct, data));
            try {
                this.deserializeAttachments.invoke((Object)template, server.registryAccess(), ct);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return template;
        }));
    }
}

