/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen.widgets;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import terrails.colorfulhearts.config.screen.HeartType;

public class HeartColorEditBox
extends EditBox {
    private static final Pattern HEX_FORMAT = Pattern.compile("^#[0-9a-fA-F]{0,6}$");
    private static final Pattern HEX_MATCH = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private boolean invalidRGBHex;
    private ResourceLocation spriteLocation;
    private Integer color;
    private final Consumer<String> defaultResponder;

    public HeartColorEditBox(Font font, int x, int y, int width, int height, HeartType heartType) {
        this(font, x, y, width, height, null, heartType);
    }

    public HeartColorEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, HeartType heartType) {
        super(font, x, y, width, height, editBox, (Component)Component.empty());
        this.setResponder(str -> {});
        this.setFilter(str -> HEX_FORMAT.matcher((CharSequence)str).matches());
        this.setMaxLength(7);
        this.defaultResponder = str -> {
            boolean bl = this.invalidRGBHex = !HEX_MATCH.matcher((CharSequence)str).matches();
            if (!this.isInvalid()) {
                this.color = Integer.decode(this.getValue());
                ResourceLocation spriteLocation = heartType.getSprite(false, false, false, this.color);
                TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(spriteLocation);
                this.spriteLocation = !sprite.contents().name().equals((Object)MissingTextureAtlasSprite.getLocation()) ? spriteLocation : null;
            }
        };
        this.defaultResponder.accept(this.getValue());
    }

    public void setResponder(Consumer<String> responder) {
        super.setResponder(str -> {
            this.defaultResponder.accept((String)str);
            responder.accept((String)str);
        });
    }

    public boolean isInvalid() {
        return this.invalidRGBHex;
    }

    public Integer getColor() {
        return this.color;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.isVisible()) {
            return;
        }
        if (this.isInvalid()) {
            if (this.isBordered()) {
                int borderColor = this.isFocused() ? -2743526 : -10942713;
                guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, borderColor);
                guiGraphics.fill(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, borderColor);
                guiGraphics.fill(this.getX(), this.getY() + 1, this.getX() + 1, this.getY() + this.height - 1, borderColor);
                guiGraphics.fill(this.getX() + this.width - 1, this.getY() + 1, this.getX() + this.width, this.getY() + this.height - 1, borderColor);
            }
        } else {
            int x = this.getX() + this.width - 11;
            int y = this.getY() + this.height / 2 - 5;
            if (this.spriteLocation != null) {
                guiGraphics.blitSprite(this.spriteLocation, x, y, 9, 9);
            } else {
                guiGraphics.fill(x, y, x + 9, y + 9, this.getColor() | 0xFF000000);
                guiGraphics.renderOutline(x, y, 9, 9, -2236963);
            }
        }
    }
}

