/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.LapisFluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class LapisFluidPipeEntity
extends FluidPipeEntity {
    private Direction entryDirection = Direction.DOWN;

    public LapisFluidPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.LAPIS_FLUID_PIPE_ENTITY, pos, state);
    }

    @Override
    public void insertFluidPacket(Level level, FluidInPipe fluidPacket) {
        this.entryDirection = fluidPacket.getFromDirection();
        super.insertFluidPacket(level, fluidPacket);
    }

    @Override
    protected List<Direction> getValidDirections(BlockState state, FluidInPipe fluidPacket) {
        boolean attached;
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction facing = ((FacingOrNone)((Object)state.getValue(LapisFluidPipeBlock.FACING))).getDirection();
        boolean bl = attached = state.getValue(LapisFluidPipeBlock.FACING) != FacingOrNone.NONE;
        if (attached && !fluidPacket.getFromDirection().equals((Object)facing) && this.isPipeConnected(state, facing)) {
            validDirections.add(facing);
        } else {
            Direction direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
            for (int i = 0; i < 5; ++i) {
                if (this.isPipeConnected(state, direction) && !direction.equals((Object)this.entryDirection)) {
                    validDirections.add(direction);
                }
                direction = MiscUtil.nextDirection(direction);
            }
            if (validDirections.isEmpty() && this.isPipeConnected(state, this.entryDirection) && attached) {
                validDirections.add(this.entryDirection);
            }
        }
        return validDirections;
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        super.loadAdditional(valueInput, registries);
        this.entryDirection = Direction.from3DDataValue((int)valueInput.getByte("entry_direction"));
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        valueOutput.putByte("entry_direction", (byte)this.entryDirection.get3DDataValue());
    }
}

