/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BrickFluidPipeBlock
extends FluidPipeBlock {
    public BrickFluidPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluidPipeEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.FLUID_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    protected boolean canConnect(Level level, BlockPos pipePos, Direction direction) {
        Block block = level.getBlockState(pipePos.relative(direction)).getBlock();
        if (block instanceof FluidPipeBlock) {
            FluidPipeBlock pipeBlock = (FluidPipeBlock)block;
            return BrickFluidPipeBlock.canConnectToPipeBothWays(this, pipeBlock);
        }
        return false;
    }
}

