/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.integration.jei;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.carving.ICarvingGroup;
import com.leclowndu93150.chisel.carving.CarvingGroup;
import com.leclowndu93150.chisel.carving.KubeJSCarvingGroup;
import com.leclowndu93150.chisel.compat.kubejs.KubeJSCompat;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselItems;
import com.leclowndu93150.chisel.integration.jei.ChiselRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ChiselJEIPlugin
implements IModPlugin {
    private ChiselRecipeCategory category;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.category = new ChiselRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.category});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<ICarvingGroup> groups = ChiselBlocks.ALL_BLOCK_TYPES.stream().map(blockType -> new CarvingGroup((ChiselBlockType<?>)blockType)).toList();
        registration.addRecipes(ChiselRecipeCategory.RECIPE_TYPE, groups);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChiselItems.IRON_CHISEL.get()), new RecipeType[]{ChiselRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChiselItems.DIAMOND_CHISEL.get()), new RecipeType[]{ChiselRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ChiselItems.HITECH_CHISEL.get()), new RecipeType[]{ChiselRecipeCategory.RECIPE_TYPE});
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        Map<ResourceLocation, Set<ResourceLocation>> kubeGroups;
        if (KubeJSCompat.isLoaded() && !(kubeGroups = KubeJSCompat.getCustomGroupsForJEI()).isEmpty()) {
            ArrayList<KubeJSCarvingGroup> kubeJSGroups = new ArrayList<KubeJSCarvingGroup>();
            for (Map.Entry<ResourceLocation, Set<ResourceLocation>> entry : kubeGroups.entrySet()) {
                boolean isExistingGroup = ChiselBlocks.ALL_BLOCK_TYPES.stream().anyMatch(bt -> {
                    ResourceLocation groupId = Chisel.id("carving/" + bt.getName());
                    return groupId.equals(entry.getKey());
                });
                if (isExistingGroup) continue;
                kubeJSGroups.add(new KubeJSCarvingGroup(entry.getKey(), entry.getValue()));
            }
            if (!kubeJSGroups.isEmpty()) {
                runtime.getRecipeManager().addRecipes(ChiselRecipeCategory.RECIPE_TYPE, kubeJSGroups);
            }
        }
    }

    public ResourceLocation getPluginUid() {
        return Chisel.id("jei_plugin");
    }
}

