/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.block.BlockCarvable;
import com.leclowndu93150.chisel.block.BlockCarvableCarpet;
import com.leclowndu93150.chisel.block.BlockCarvableGlass;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ChiselRecipeProvider
extends RecipeProvider {
    public ChiselRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.buildToolRecipes(output);
        this.buildAutoChiselRecipe(output);
        this.buildFactoryRecipes(output);
        this.buildLaboratoryRecipes(output);
        this.buildAntiblockRecipes(output);
        this.buildBrownstoneRecipes(output);
        this.buildVoidstoneRecipes(output);
        this.buildCharcoalRecipes(output);
        this.buildHexplatingRecipes(output);
        this.buildFuturaRecipes(output);
        this.buildValentinesRecipes(output);
        this.buildCustomStoneRecipes(output);
        this.buildWaterstoneRecipes(output);
        this.buildLavastoneRecipes(output);
        this.buildIceRecipes(output);
        this.buildMiscellaneousRecipes(output);
        this.buildGlassRecipes(output);
        this.buildBookshelfRecipes(output);
        this.buildFantasyRecipes(output);
        this.buildWarningRecipes(output);
        this.buildHolystoneRecipes(output);
        this.buildCarpetRecipes(output);
        this.buildStonecutterRecipes(output);
    }

    private void buildToolRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ChiselItems.IRON_CHISEL.get())).pattern(" I").pattern("S ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_iron", ChiselRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ChiselItems.DIAMOND_CHISEL.get())).pattern(" D").pattern("S ").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_diamond", ChiselRecipeProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ChiselItems.HITECH_CHISEL.get())).requires((ItemLike)ChiselItems.DIAMOND_CHISEL.get()).requires(Tags.Items.INGOTS_GOLD).requires(Tags.Items.DUSTS_REDSTONE).unlockedBy("has_diamond_chisel", ChiselRecipeProvider.has((ItemLike)((ItemLike)ChiselItems.DIAMOND_CHISEL.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ChiselItems.OFFSET_TOOL.get())).pattern(" E").pattern("S ").define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_ender_pearl", ChiselRecipeProvider.has((TagKey)Tags.Items.ENDER_PEARLS)).save(output);
    }

    private void buildAutoChiselRecipe(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ChiselItems.AUTO_CHISEL.get())).pattern("GGG").pattern("GRG").pattern("III").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_redstone", ChiselRecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(output);
    }

    private void buildFactoryRecipes(RecipeOutput output) {
        if (ChiselBlocks.FACTORY.getBlock("dots") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FACTORY.getBlock("dots").get()), (int)32).pattern("SXS").pattern("X X").pattern("SXS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('X'), Tags.Items.INGOTS_IRON).unlockedBy("has_iron", ChiselRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(output, Chisel.id("factory/dots"));
        }
    }

    private void buildLaboratoryRecipes(RecipeOutput output) {
        if (ChiselBlocks.LABORATORY.getBlock("largesteel") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.LABORATORY.getBlock("largesteel").get()), (int)8).pattern("SSS").pattern("SQS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)Blocks.STONE).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).unlockedBy("has_quartz", ChiselRecipeProvider.has((ItemLike)Items.QUARTZ)).save(output, Chisel.id("laboratory/largesteel"));
        }
    }

    private void buildAntiblockRecipes(RecipeOutput output) {
        DeferredBlock<BlockCarvable> block = ChiselBlocks.ANTIBLOCK.getBlock("white");
        if (block != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)block.get()), (int)8).pattern(" S ").pattern("SGS").pattern(" S ").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).unlockedBy("has_glowstone", ChiselRecipeProvider.has((ItemLike)Blocks.GLOWSTONE)).save(output, Chisel.id("antiblock/white"));
        }
    }

    private void buildBrownstoneRecipes(RecipeOutput output) {
        if (ChiselBlocks.BROWNSTONE.getBlock("default") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.BROWNSTONE.getBlock("default").get()), (int)4).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('S'), Tags.Items.SANDSTONE_BLOCKS).define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).unlockedBy("has_clay", ChiselRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(output, Chisel.id("brownstone/default"));
        }
    }

    private void buildVoidstoneRecipes(RecipeOutput output) {
        if (ChiselBlocks.VOIDSTONE.getBlock("bevel") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE.getBlock("bevel").get()), (int)16).pattern(" E ").pattern("OOO").pattern(" E ").define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('O'), Tags.Items.OBSIDIANS).unlockedBy("has_ender_eye", ChiselRecipeProvider.has((ItemLike)Items.ENDER_EYE)).save(output, Chisel.id("voidstone/bevel_from_obsidian"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE.getBlock("bevel").get()), (int)48).pattern(" P ").pattern("PEP").pattern(" P ").define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('P'), (ItemLike)Blocks.PURPUR_BLOCK).unlockedBy("has_purpur", ChiselRecipeProvider.has((ItemLike)Blocks.PURPUR_BLOCK)).save(output, Chisel.id("voidstone/bevel_from_purpur"));
        }
    }

    private void buildCharcoalRecipes(RecipeOutput output) {
        if (ChiselBlocks.CHARCOAL.getBlock("raw") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.CHARCOAL.getBlock("raw").get())).pattern("CCC").pattern("CCC").pattern("CCC").define(Character.valueOf('C'), (ItemLike)Items.CHARCOAL).unlockedBy("has_charcoal", ChiselRecipeProvider.has((ItemLike)Items.CHARCOAL)).save(output, Chisel.id("charcoal/raw"));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHARCOAL, (int)9).requires((ItemLike)ChiselBlocks.CHARCOAL.getBlock("raw").get()).unlockedBy("has_charcoal_block", ChiselRecipeProvider.has((ItemLike)((ItemLike)ChiselBlocks.CHARCOAL.getBlock("raw").get()))).save(output, Chisel.id("charcoal/raw_uncraft"));
        }
    }

    private void buildHexplatingRecipes(RecipeOutput output) {
        for (DyeColor color : DyeColor.values()) {
            DeferredBlock<BlockCarvable> block;
            ChiselBlockType<BlockCarvable> hexType = ChiselBlocks.HEX_PLATING.get(color);
            if (hexType == null || (block = hexType.getBlock("hexbase")) == null) continue;
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)block.get()), (int)8).pattern("SSS").pattern("SDS").pattern("NNN").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('D'), color.getTag()).define(Character.valueOf('N'), Tags.Items.NUGGETS_IRON).unlockedBy("has_dye", ChiselRecipeProvider.has((TagKey)color.getTag())).save(output, Chisel.id("hexplating/" + color.getSerializedName() + "_hexbase"));
        }
    }

    private void buildFuturaRecipes(RecipeOutput output) {
        if (ChiselBlocks.FUTURA.getBlock("controller") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FUTURA.getBlock("controller").get()), (int)8).pattern("IGI").pattern("GRG").pattern("IGI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_glowstone", ChiselRecipeProvider.has((ItemLike)Blocks.GLOWSTONE)).save(output, Chisel.id("futura/controller"));
        }
    }

    private void buildValentinesRecipes(RecipeOutput output) {
        if (ChiselBlocks.VALENTINES.getBlock("companion") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VALENTINES.getBlock("companion").get()), (int)8).pattern("WWW").pattern("WRW").pattern("WWW").define(Character.valueOf('W'), (ItemLike)Blocks.PINK_WOOL).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_BLOCK).unlockedBy("has_redstone_block", ChiselRecipeProvider.has((ItemLike)Blocks.REDSTONE_BLOCK)).save(output, Chisel.id("valentines/companion"));
        }
    }

    private void buildCustomStoneRecipes(RecipeOutput output) {
        if (ChiselBlocks.MARBLE.getBlock("raw") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.MARBLE.getBlock("raw").get()), (int)4).pattern("SB").pattern("BS").define(Character.valueOf('S'), (ItemLike)Blocks.STONE).define(Character.valueOf('B'), (ItemLike)Items.BONE_MEAL).unlockedBy("has_bone_meal", ChiselRecipeProvider.has((ItemLike)Items.BONE_MEAL)).save(output, Chisel.id("marble/raw"));
        }
        if (ChiselBlocks.LIMESTONE.getBlock("raw") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.LIMESTONE.getBlock("raw").get()), (int)4).pattern("SG").pattern("GS").define(Character.valueOf('S'), (ItemLike)Blocks.STONE).define(Character.valueOf('G'), (ItemLike)Blocks.GRAVEL).unlockedBy("has_gravel", ChiselRecipeProvider.has((ItemLike)Blocks.GRAVEL)).save(output, Chisel.id("limestone/raw"));
        }
    }

    private void buildWaterstoneRecipes(RecipeOutput output) {
        if (ChiselBlocks.WATERSTONE.getBlock("cracked") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.WATERSTONE.getBlock("cracked").get()), (int)8).pattern("SSS").pattern("SWS").pattern("SSS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).unlockedBy("has_water_bucket", ChiselRecipeProvider.has((ItemLike)Items.WATER_BUCKET)).save(output, Chisel.id("waterstone/cracked"));
        }
    }

    private void buildLavastoneRecipes(RecipeOutput output) {
        if (ChiselBlocks.LAVASTONE.getBlock("cracked") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.LAVASTONE.getBlock("cracked").get()), (int)8).pattern("SSS").pattern("SLS").pattern("SSS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).unlockedBy("has_lava_bucket", ChiselRecipeProvider.has((ItemLike)Items.LAVA_BUCKET)).save(output, Chisel.id("lavastone/cracked"));
        }
    }

    private void buildIceRecipes(RecipeOutput output) {
        if (ChiselBlocks.ICE.getBlock("cube") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.ICE.getBlock("cube").get()), (int)8).pattern("III").pattern("I I").pattern("III").define(Character.valueOf('I'), (ItemLike)Items.PACKED_ICE).unlockedBy("has_packed_ice", ChiselRecipeProvider.has((ItemLike)Items.PACKED_ICE)).save(output, Chisel.id("ice/cube"));
        }
        if (ChiselBlocks.ICE_PILLAR.getBlock("plain") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.ICE_PILLAR.getBlock("plain").get()), (int)8).pattern("III").pattern("I I").pattern("III").define(Character.valueOf('I'), (ItemLike)Items.ICE).unlockedBy("has_ice", ChiselRecipeProvider.has((ItemLike)Items.ICE)).save(output, Chisel.id("ice_pillar/plain"));
        }
    }

    private void buildMiscellaneousRecipes(RecipeOutput output) {
        if (ChiselBlocks.CLOUD.getBlock("cloud") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.CLOUD.getBlock("cloud").get()), (int)8).pattern("WWW").pattern("WPW").pattern("WWW").define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('P'), (ItemLike)Items.PHANTOM_MEMBRANE).unlockedBy("has_phantom_membrane", ChiselRecipeProvider.has((ItemLike)Items.PHANTOM_MEMBRANE)).save(output, Chisel.id("cloud/cloud"));
        }
        if (ChiselBlocks.FUTURA.getBlock("screen_metallic") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FUTURA.getBlock("screen_metallic").get()), (int)8).pattern("IGI").pattern("GRG").pattern("IGI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_glowstone", ChiselRecipeProvider.has((ItemLike)Blocks.GLOWSTONE)).save(output, Chisel.id("futura/screen_metallic"));
        }
        if (ChiselBlocks.TECHNICAL.getBlock("scaffold") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TECHNICAL.getBlock("scaffold").get()), (int)16).pattern("I I").pattern("III").pattern("I I").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_iron", ChiselRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(output, Chisel.id("technical/scaffold"));
        }
        if (ChiselBlocks.TYRIAN.getBlock("tyrian") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TYRIAN.getBlock("tyrian").get()), (int)8).pattern("SSS").pattern("SPS").pattern("SSS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('P'), (ItemLike)Blocks.PURPUR_BLOCK).unlockedBy("has_purpur", ChiselRecipeProvider.has((ItemLike)Blocks.PURPUR_BLOCK)).save(output, Chisel.id("tyrian/tyrian"));
        }
        if (ChiselBlocks.VOIDSTONE_ENERGISED.getBlock("raw") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE_ENERGISED.getBlock("raw").get()), (int)8).pattern("OOO").pattern("OGO").pattern("OOO").define(Character.valueOf('O'), Tags.Items.OBSIDIANS).define(Character.valueOf('G'), (ItemLike)Blocks.GLOWSTONE).unlockedBy("has_obsidian", ChiselRecipeProvider.has((TagKey)Tags.Items.OBSIDIANS)).save(output, Chisel.id("energized_voidstone/raw"));
        }
        if (ChiselBlocks.VOIDSTONE_RUNIC.getBlock("black") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.VOIDSTONE_RUNIC.getBlock("black").get()), (int)8).pattern("OOO").pattern("OEO").pattern("OOO").define(Character.valueOf('O'), Tags.Items.OBSIDIANS).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).unlockedBy("has_ender_eye", ChiselRecipeProvider.has((ItemLike)Items.ENDER_EYE)).save(output, Chisel.id("runic_voidstone/black"));
        }
        if (ChiselBlocks.MARBLE_PILLAR.getBlock("pillar") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.MARBLE_PILLAR.getBlock("pillar").get()), (int)4).pattern("SB").pattern("BS").define(Character.valueOf('S'), (ItemLike)Blocks.STONE).define(Character.valueOf('B'), (ItemLike)Items.BONE_MEAL).unlockedBy("has_bone_meal", ChiselRecipeProvider.has((ItemLike)Items.BONE_MEAL)).save(output, Chisel.id("marble_pillar/pillar"));
        }
        if (ChiselBlocks.PAPER.getBlock("box") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.PAPER.getBlock("box").get())).pattern("PPP").pattern("PPP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)Items.PAPER).unlockedBy("has_paper", ChiselRecipeProvider.has((ItemLike)Items.PAPER)).save(output, Chisel.id("paper/box"));
        }
        if (ChiselBlocks.SANDSTONE_SCRIBBLES.getBlock("scribbles_0") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.SANDSTONE_SCRIBBLES.getBlock("scribbles_0").get()), (int)4).pattern("SS").pattern("SS").define(Character.valueOf('S'), Tags.Items.SANDSTONE_BLOCKS).unlockedBy("has_sandstone", ChiselRecipeProvider.has((TagKey)Tags.Items.SANDSTONE_BLOCKS)).save(output, Chisel.id("sandstone_scribbles/scribbles_0"));
        }
        if (ChiselBlocks.RED_SANDSTONE_SCRIBBLES.getBlock("scribbles_0") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.RED_SANDSTONE_SCRIBBLES.getBlock("scribbles_0").get()), (int)4).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)Blocks.RED_SANDSTONE).unlockedBy("has_red_sandstone", ChiselRecipeProvider.has((ItemLike)Blocks.RED_SANDSTONE)).save(output, Chisel.id("red_sandstone_scribbles/scribbles_0"));
        }
        if (ChiselBlocks.TEMPLE.getBlock("bricks") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TEMPLE.getBlock("bricks").get()), (int)4).pattern("SC").pattern("CS").define(Character.valueOf('S'), (ItemLike)Blocks.STONE_BRICKS).define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).unlockedBy("has_stone_bricks", ChiselRecipeProvider.has((ItemLike)Blocks.STONE_BRICKS)).save(output, Chisel.id("temple/bricks"));
        }
        if (ChiselBlocks.TEMPLE_MOSSY.getBlock("bricks") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.TEMPLE_MOSSY.getBlock("bricks").get()), (int)4).pattern("SC").pattern("CS").define(Character.valueOf('S'), (ItemLike)Blocks.MOSSY_STONE_BRICKS).define(Character.valueOf('C'), (ItemLike)Blocks.MOSSY_COBBLESTONE).unlockedBy("has_mossy_stone_bricks", ChiselRecipeProvider.has((ItemLike)Blocks.MOSSY_STONE_BRICKS)).save(output, Chisel.id("templemossy/bricks"));
        }
    }

    private void buildGlassRecipes(RecipeOutput output) {
        for (DyeColor color : DyeColor.values()) {
            DeferredBlock<BlockCarvableGlass> baseBlock;
            ChiselBlockType<BlockCarvableGlass> dyedGlassType = ChiselBlocks.GLASS_DYED.get(color);
            if (dyedGlassType == null || (baseBlock = dyedGlassType.getBlock("bubble")) == null) continue;
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)baseBlock.get()), (int)8).pattern("GGG").pattern("GDG").pattern("GGG").define(Character.valueOf('G'), (ItemLike)ChiselRecipeProvider.getStainedGlassBlock(color)).define(Character.valueOf('D'), color.getTag()).unlockedBy("has_stained_glass", ChiselRecipeProvider.has((ItemLike)ChiselRecipeProvider.getStainedGlassBlock(color))).save(output, Chisel.id("glassdyed/" + color.getSerializedName() + "_bubble"));
        }
    }

    private static Block getStainedGlassBlock(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_STAINED_GLASS;
            case DyeColor.ORANGE -> Blocks.ORANGE_STAINED_GLASS;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_STAINED_GLASS;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_STAINED_GLASS;
            case DyeColor.YELLOW -> Blocks.YELLOW_STAINED_GLASS;
            case DyeColor.LIME -> Blocks.LIME_STAINED_GLASS;
            case DyeColor.PINK -> Blocks.PINK_STAINED_GLASS;
            case DyeColor.GRAY -> Blocks.GRAY_STAINED_GLASS;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_STAINED_GLASS;
            case DyeColor.CYAN -> Blocks.CYAN_STAINED_GLASS;
            case DyeColor.PURPLE -> Blocks.PURPLE_STAINED_GLASS;
            case DyeColor.BLUE -> Blocks.BLUE_STAINED_GLASS;
            case DyeColor.BROWN -> Blocks.BROWN_STAINED_GLASS;
            case DyeColor.GREEN -> Blocks.GREEN_STAINED_GLASS;
            case DyeColor.RED -> Blocks.RED_STAINED_GLASS;
            case DyeColor.BLACK -> Blocks.BLACK_STAINED_GLASS;
        };
    }

    private void buildBookshelfRecipes(RecipeOutput output) {
        String[] woodTypes;
        for (String woodType : woodTypes = new String[]{"spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped"}) {
            DeferredBlock<BlockCarvable> baseBlock;
            ChiselBlockType<BlockCarvable> bookshelfType = ChiselBlocks.BOOKSHELVES.get(woodType);
            if (bookshelfType == null || (baseBlock = bookshelfType.getBlock("rainbow")) == null) continue;
            Item slab = this.getSlabItem(woodType);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)baseBlock.get())).pattern("SSS").pattern("BBB").pattern("SSS").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('B'), (ItemLike)Items.BOOK).unlockedBy("has_book", ChiselRecipeProvider.has((ItemLike)Items.BOOK)).save(output, Chisel.id("bookshelf/" + woodType + "_rainbow"));
        }
    }

    private Item getSlabItem(String woodType) {
        return switch (woodType) {
            case "oak" -> Items.OAK_SLAB;
            case "spruce" -> Items.SPRUCE_SLAB;
            case "birch" -> Items.BIRCH_SLAB;
            case "jungle" -> Items.JUNGLE_SLAB;
            case "acacia" -> Items.ACACIA_SLAB;
            case "dark_oak" -> Items.DARK_OAK_SLAB;
            case "mangrove" -> Items.MANGROVE_SLAB;
            case "cherry" -> Items.CHERRY_SLAB;
            case "bamboo" -> Items.BAMBOO_SLAB;
            case "crimson" -> Items.CRIMSON_SLAB;
            case "warped" -> Items.WARPED_SLAB;
            default -> Items.OAK_SLAB;
        };
    }

    private void buildFantasyRecipes(RecipeOutput output) {
        if (ChiselBlocks.FANTASY.getBlock("brick") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FANTASY.getBlock("brick").get()), (int)8).pattern("SSS").pattern("SGS").pattern("SSS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('G'), Tags.Items.NUGGETS_GOLD).unlockedBy("has_gold_nugget", ChiselRecipeProvider.has((TagKey)Tags.Items.NUGGETS_GOLD)).save(output, Chisel.id("fantasy/brick"));
        }
        if (ChiselBlocks.FANTASY2.getBlock("brick") != null && ChiselBlocks.FANTASY.getBlock("brick") != null) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.FANTASY2.getBlock("brick").get())).requires((ItemLike)ChiselBlocks.FANTASY.getBlock("brick").get()).requires(Tags.Items.DYES_WHITE).unlockedBy("has_fantasy", ChiselRecipeProvider.has((ItemLike)((ItemLike)ChiselBlocks.FANTASY.getBlock("brick").get()))).save(output, Chisel.id("fantasy2/brick"));
        }
    }

    private void buildWarningRecipes(RecipeOutput output) {
        if (ChiselBlocks.WARNING.getBlock("radiation") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.WARNING.getBlock("radiation").get()), (int)4).pattern("SSS").pattern("SIS").pattern("SSS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('I'), (ItemLike)Items.OAK_SIGN).unlockedBy("has_sign", ChiselRecipeProvider.has((ItemLike)Items.OAK_SIGN)).save(output, Chisel.id("warning/radiation"));
        }
    }

    private void buildHolystoneRecipes(RecipeOutput output) {
        if (ChiselBlocks.HOLYSTONE.getBlock("raw") != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ChiselBlocks.HOLYSTONE.getBlock("raw").get()), (int)8).pattern("SSS").pattern("SFS").pattern("SSS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).unlockedBy("has_feather", ChiselRecipeProvider.has((ItemLike)Items.FEATHER)).save(output, Chisel.id("holystone/raw"));
        }
    }

    private void buildCarpetRecipes(RecipeOutput output) {
        for (DyeColor color : DyeColor.values()) {
            ChiselBlockType<BlockCarvableCarpet> carpetType = ChiselBlocks.CARPET.get(color);
            ChiselBlockType<BlockCarvable> woolType = ChiselBlocks.WOOL.get(color);
            if (carpetType == null || woolType == null) continue;
            DeferredBlock<BlockCarvable> legacyWool = woolType.getBlock("legacy");
            DeferredBlock<BlockCarvableCarpet> legacyCarpet = carpetType.getBlock("legacy");
            if (legacyWool != null && legacyCarpet != null) {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)legacyCarpet.get()), (int)3).pattern("WW").define(Character.valueOf('W'), (ItemLike)legacyWool.get()).unlockedBy("has_wool", ChiselRecipeProvider.has((ItemLike)((ItemLike)legacyWool.get()))).save(output, Chisel.id("carpet/" + color.getSerializedName() + "_legacy"));
            }
            DeferredBlock<BlockCarvable> llamaWool = woolType.getBlock("llama");
            DeferredBlock<BlockCarvableCarpet> llamaCarpet = carpetType.getBlock("llama");
            if (llamaWool == null || llamaCarpet == null) continue;
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)llamaCarpet.get()), (int)3).pattern("WW").define(Character.valueOf('W'), (ItemLike)llamaWool.get()).unlockedBy("has_wool", ChiselRecipeProvider.has((ItemLike)((ItemLike)llamaWool.get()))).save(output, Chisel.id("carpet/" + color.getSerializedName() + "_llama"));
        }
    }

    private void buildStonecutterRecipes(RecipeOutput output) {
        for (ChiselBlockType<?> blockType : ChiselBlocks.ALL_BLOCK_TYPES) {
            TagKey itemTag = ItemTags.create((ResourceLocation)blockType.getCarvingGroupTag().location());
            for (DeferredBlock<?> block : blockType.getAllBlocks()) {
                String variantName = this.getVariantName(block);
                SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((TagKey)itemTag), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)block.get())).unlockedBy("has_block", ChiselRecipeProvider.has((TagKey)itemTag)).save(output, Chisel.id(blockType.getName().replace("/", "_") + "/" + variantName + "_from_stonecutting"));
            }
        }
    }

    private String getVariantName(DeferredBlock<?> block) {
        String fullName = block.getId().getPath();
        int lastSlash = fullName.lastIndexOf(47);
        return lastSlash >= 0 ? fullName.substring(lastSlash + 1) : fullName;
    }
}

