/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data.provider;

import com.leclowndu93150.chisel.api.block.ChiselBlockType;
import com.leclowndu93150.chisel.api.block.ICarvable;
import com.leclowndu93150.chisel.api.block.VariationData;
import com.leclowndu93150.chisel.init.ChiselBlocks;
import com.leclowndu93150.chisel.init.ChiselItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ChiselLanguageProvider
extends LanguageProvider {
    public ChiselLanguageProvider(PackOutput output) {
        super(output, "chisel", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.chisel", "Chisel");
        for (ChiselBlockType<?> blockType : ChiselBlocks.ALL_BLOCK_TYPES) {
            String groupName = blockType.getGroupName();
            for (DeferredBlock<?> deferredBlock : blockType.getAllBlocks()) {
                Block block = (Block)deferredBlock.get();
                if (!(block instanceof ICarvable)) continue;
                ICarvable carvable = (ICarvable)block;
                VariationData variation = carvable.getVariation();
                String displayName = groupName + " - " + variation.localizedName();
                this.add(block, displayName);
            }
        }
        this.add((Item)ChiselItems.IRON_CHISEL.get(), "Chisel");
        this.add((Item)ChiselItems.DIAMOND_CHISEL.get(), "Diamond Chisel");
        this.add((Item)ChiselItems.HITECH_CHISEL.get(), "iChisel");
        this.add((Item)ChiselItems.OFFSET_TOOL.get(), "Ender Offset Wand");
        this.add("jei.chisel.chiseling", "Chiseling");
        this.add("jei.chisel.no_craftable", "No Craftable Block");
        this.add("chisel.tooltip.gui", "Right-click to open GUI");
        this.add("chisel.tooltip.leftclick.1", "Left-click blocks to cycle variants forward");
        this.add("chisel.tooltip.leftclick.2", "Shift + Left-click to cycle backwards");
        this.add("chisel.tooltip.target", "Set a target in the GUI to chisel to a specific variant");
        this.add("chisel.tooltip.modes", "Shift + Right-click to change mode");
        this.add("chisel.tooltip.selectedmode", "Selected mode: %s");
        this.add("chisel.tooltip.offset_tool.1", "Right-click a block to cycle texture offset");
        this.add("chisel.tooltip.offset_tool.2", "Sneak + Right-click to reset offset");
        this.add("container.chisel", "Chisel");
        this.add("container.chisel.hitech", "iChisel");
        this.add("chisel.button.preview", "Preview");
        this.add("chisel.button.chisel", "Chisel");
        this.add("chisel.button.chisel_all", "Chisel All");
        this.add("chisel.preview", "Preview");
        this.add("chisel.preview.panel", "Panel");
        this.add("chisel.preview.hollow", "Hollow");
        this.add("chisel.preview.plus", "Plus");
        this.add("chisel.preview.single", "Single");
        this.add("chisel.message.mode_changed", "Mode changed to: %s");
        this.add("chisel.message.cooldown", "Chisel on cooldown: %ss");
        this.add("chisel.mode.single", "Single");
        this.add("chisel.mode.single.desc", "Chisel a single block.");
        this.add("chisel.mode.panel", "Panel");
        this.add("chisel.mode.panel.desc", "Chisel a 3x3 square of blocks.");
        this.add("chisel.mode.column", "Column");
        this.add("chisel.mode.column.desc", "Chisel a 3x1 column of blocks.");
        this.add("chisel.mode.row", "Row");
        this.add("chisel.mode.row.desc", "Chisel a 1x3 row of blocks.");
        this.add("chisel.mode.contiguous", "Contiguous");
        this.add("chisel.mode.contiguous.desc", "Chisel an area of alike blocks, extending 10 blocks in any direction.");
        this.add("chisel.mode.contiguous_2d", "Contiguous (2D)");
        this.add("chisel.mode.contiguous_2d.desc", "Chisel an area of alike blocks, extending 10 blocks along the plane of the current side.");
        this.add((Block)ChiselBlocks.AUTO_CHISEL.get(), "Auto Chisel");
        this.add("chisel.tooltip.power.stored", "%s/%s FE");
        this.add("chisel.tooltip.power.pertick", "%s FE/t");
        this.add("chisel.tooltip.brownstone.speed", "Walking on this block increases your speed");
        this.add("chisel.tooltip.holystone.glow", "Emits a holy glow and sparkles");
    }
}

