/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.utils;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractResourceContainerContainerAdapter
implements Container {
    private final ResourceContainer container;

    protected AbstractResourceContainerContainerAdapter(ResourceContainer container) {
        this.container = container;
    }

    public int getContainerSize() {
        return this.container.size();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.container.size(); ++i) {
            if (this.container.isEmpty(i)) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slotIndex) {
        return this.container.getStackRepresentation(slotIndex);
    }

    public ItemStack removeItem(int slotIndex, int amount) {
        PlatformResourceKey resource = this.container.getResource(slotIndex);
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            long maxRemove = Math.min((long)amount, this.container.getAmount(slotIndex));
            this.container.shrink(slotIndex, maxRemove);
            return itemResource.toItemStack(maxRemove);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slotIndex) {
        PlatformResourceKey resource = this.container.getResource(slotIndex);
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            ItemStack stack = itemResource.toItemStack();
            long maxRemove = Math.min(Math.max(this.container.getMaxAmount((ResourceKey)resource), (long)stack.getMaxStackSize()), this.container.getAmount(slotIndex));
            this.container.shrink(slotIndex, maxRemove);
            return stack.copyWithCount((int)maxRemove);
        }
        return ItemStack.EMPTY;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (this.container.isEmpty(slot)) {
            return true;
        }
        PlatformResourceKey current = this.container.getResource(slot);
        if (!(current instanceof ItemResource)) {
            return false;
        }
        ItemResource resource = ItemResource.ofItemStack((ItemStack)stack);
        return resource.equals((Object)current) && this.container.getAmount(slot) + (long)stack.getCount() <= Math.max(this.container.getMaxAmount((ResourceKey)resource), (long)stack.getMaxStackSize());
    }

    public void setItem(int slotIndex, ItemStack itemStack) {
        PlatformResourceKey resource = this.container.getResource(slotIndex);
        if (itemStack.isEmpty()) {
            if (resource instanceof ItemResource) {
                this.container.remove(slotIndex);
            }
            return;
        }
        this.container.set(slotIndex, new ResourceAmount((ResourceKey)ItemResource.ofItemStack((ItemStack)itemStack), (long)itemStack.getCount()));
    }

    public int getMaxStackSize() {
        return this.getMaxStackSize(ItemStack.EMPTY);
    }

    public int getMaxStackSize(ItemStack stack) {
        return (int)Math.clamp(0L, this.container.getMaxAmount((ResourceKey)ItemResource.ofItemStack((ItemStack)stack)), Integer.MAX_VALUE);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.container.size(); ++i) {
            this.container.remove(i);
        }
    }
}

