/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.busy_villagers.mixin;

import com.breakinblocks.busy_villagers.Config;
import net.minecraft.world.entity.npc.Villager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Villager.class})
public abstract class VillagerMixin {
    @Shadow
    private long lastRestockGameTime;
    @Shadow
    private int numberOfRestocksToday;

    @Shadow
    protected abstract boolean needsToRestock();

    @Shadow
    protected abstract void resetNumberOfRestocks();

    @Overwrite
    public boolean shouldRestock() {
        boolean shouldReset;
        Villager villager = (Villager)this;
        long restockResetTime = this.lastRestockGameTime + (long)Config.restockResetMinutes * 1200L;
        long currentGameTime = villager.level().getGameTime();
        boolean bl = shouldReset = currentGameTime > restockResetTime;
        if (shouldReset) {
            this.lastRestockGameTime = currentGameTime;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    @Overwrite
    private boolean allowedToRestock() {
        Villager villager = (Villager)this;
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < Config.maxRestocksPerPeriod && villager.level().getGameTime() > this.lastRestockGameTime + (long)Config.restockCooldownMinutes * 1200L;
    }

    @Overwrite
    private boolean golemSpawnConditionsMet(long l) {
        return true;
    }
}

