/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.widgets;

import com.davenonymous.bonsaitrees.lib.gui.GUIHelper;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetWithValue;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WidgetItemStack
extends WidgetWithValue<ItemStack> {
    boolean drawSlot = false;
    boolean grayOut = false;
    boolean drawTooltip = true;

    public WidgetItemStack(ItemStack stack) {
        this.setSize(16, 16);
        this.setValue(stack);
    }

    public WidgetItemStack(ItemStack stack, boolean drawSlot) {
        this(stack);
        this.drawSlot = drawSlot;
    }

    public WidgetItemStack setDrawSlot(boolean drawSlot) {
        this.drawSlot = drawSlot;
        return this;
    }

    public WidgetItemStack setDrawTooltip(boolean drawTooltip) {
        this.drawTooltip = drawTooltip;
        this.setValue((ItemStack)this.value);
        return this;
    }

    public WidgetItemStack setGrayOut(boolean grayOut) {
        this.grayOut = grayOut;
        return this;
    }

    @Override
    public void setValue(ItemStack stack) {
        this.setTooltipLines(Collections.emptyList());
        if (this.drawTooltip && !stack.isEmpty()) {
            TooltipFlag.Default tooltipFlag = Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            this.setTooltipLines(stack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)Minecraft.getInstance().player, (TooltipFlag)tooltipFlag));
        }
        super.setValue(stack);
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        super.draw(pGuiGraphics, screen);
        if (this.drawSlot) {
            this.drawSlot(pGuiGraphics, screen);
        }
        if (this.value == null || ((ItemStack)this.value).isEmpty()) {
            return;
        }
        if (!this.visible || !this.areAllParentsVisible()) {
            return;
        }
        if (this.drawSlot && this.grayOut) {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            float[] oldColor = RenderSystem.getShaderColor();
            pGuiGraphics.setColor(r, g, b, 1.0f);
            pGuiGraphics.renderItem((ItemStack)this.value, 0, 0);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.8f);
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            this.drawOverlay(pGuiGraphics, screen);
            pGuiGraphics.pose().popPose();
            RenderSystem.setShaderColor((float)oldColor[0], (float)oldColor[1], (float)oldColor[2], (float)oldColor[3]);
        } else if (this.grayOut) {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            pGuiGraphics.setColor(r, g, b, 0.3f);
            pGuiGraphics.renderItem((ItemStack)this.value, 0, 0);
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.8f);
        } else {
            pGuiGraphics.renderItem((ItemStack)this.value, 0, 0);
        }
    }

    private void drawSlot(GuiGraphics pGuiGraphics, Screen screen) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUIHelper.tabIcons);
        int texOffsetY = 84;
        int texOffsetX = 84;
        pGuiGraphics.blit(GUIHelper.tabIcons, -1, -1, texOffsetX, texOffsetY, 18, 18);
    }

    private void drawOverlay(GuiGraphics pGuiGraphics, Screen screen) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUIHelper.tabIcons);
        int texOffsetY = 85;
        int texOffsetX = 85;
        pGuiGraphics.blit(GUIHelper.tabIcons, 0, 0, texOffsetX, texOffsetY, 16, 16);
    }
}

