/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.widgets;

import com.davenonymous.bonsaitrees.lib.gui.DynamicImageResources;
import com.davenonymous.bonsaitrees.lib.gui.widgets.Widget;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.Size2i;

public class WidgetImage
extends Widget {
    ResourceLocation image;
    float textureWidth = 16.0f;
    float textureHeight = 16.0f;
    int color = 0xFFFFFF;
    float alpha = 1.0f;
    float scale = 1.0f;
    Size2i offset = new Size2i(0, 0);

    public WidgetImage(ResourceLocation image) {
        this.image = image;
    }

    public WidgetImage(DynamicImageResources.DynTexture logo) {
        this.image = logo.resource();
        this.textureWidth = logo.image().getWidth();
        this.textureHeight = logo.image().getHeight();
    }

    public WidgetImage setTextureSize(float width, float height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    public WidgetImage setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public WidgetImage setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public WidgetImage setOffset(Size2i offset) {
        this.offset = offset;
        return this;
    }

    public WidgetImage setOffset(int x, int y) {
        return this.setOffset(new Size2i(x, y));
    }

    public WidgetImage setColor(int color) {
        this.alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        this.color = color & 0xFFFFFF;
        return this;
    }

    public WidgetImage resetColor() {
        this.alpha = 1.0f;
        this.color = 0xFFFFFF;
        return this;
    }

    public WidgetImage setImage(ResourceLocation image) {
        this.image = image;
        return this;
    }

    public float textureHeight() {
        return this.textureHeight;
    }

    public float textureWidth() {
        return this.textureWidth;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        if (this.visible && this.areAllParentsVisible()) {
            RenderSystem.enableBlend();
            float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)this.alpha);
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().scale(this.scale, this.scale, 1.0f);
            pGuiGraphics.blitInscribed(this.image, this.offset.width, this.offset.height, this.width, this.height, (int)this.textureWidth, (int)this.textureHeight, true, true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            pGuiGraphics.pose().popPose();
        }
    }
}

