/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.datacomponents;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ToolDataComponent(ItemStack tool) {
    public static final Codec<ToolDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("tool").forGetter(ToolDataComponent::tool)).apply((Applicative)instance, ToolDataComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToolDataComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ToolDataComponent::tool, ToolDataComponent::new);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        ItemStack thatTool;
        if (!(o instanceof ToolDataComponent)) return false;
        ToolDataComponent toolDataComponent = (ToolDataComponent)o;
        try {
            ItemStack itemStack;
            thatTool = itemStack = toolDataComponent.tool();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.tool, (ItemStack)thatTool)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return ItemStack.hashItemAndComponents((ItemStack)this.tool);
    }
}

