/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class CobbleCrafterItem
extends Item {
    public CobbleCrafterItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CraftingMenu(this, windowId, playerInventory, ContainerLevelAccess.create((Level)level, (BlockPos)player.blockPosition())){

                public boolean stillValid(@NotNull Player p) {
                    return true;
                }
            }, (Component)Component.translatable((String)"container.crafting")));
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return super.use(level, player, hand);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (player == null || level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            int currentMode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
            int nextMode = (currentMode + 1) % 3;
            stack.set(ModDataComponents.BUILDER_MODE, (Object)nextMode);
            String msg = switch (nextMode) {
                case 0 -> "Mode: Single Block";
                case 1 -> "Mode: Line (7 blocks)";
                case 2 -> "Mode: Platform (7x7)";
                default -> "Unknown Mode";
            };
            player.displayClientMessage((Component)Component.literal((String)msg), true);
            return InteractionResult.CONSUME;
        }
        Block blockToPlace = Blocks.COBBLESTONE;
        BlockState newState = blockToPlace.defaultBlockState();
        int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (mode == 0) {
            positions.add(pos.relative(face));
        } else if (mode == 1) {
            startPos = pos.relative(face);
            Direction lineDir = face.getAxis().isHorizontal() ? (player.getViewXRot(1.0f) < -30.0f ? Direction.UP : (player.getViewXRot(1.0f) > 30.0f ? Direction.DOWN : player.getDirection())) : player.getDirection();
            for (int i = 0; i < 7; ++i) {
                positions.add(startPos.relative(lineDir, i));
            }
        } else if (mode == 2) {
            startPos = pos.relative(face);
            if (face == Direction.UP || face == Direction.DOWN) {
                Direction forward = player.getDirection();
                Direction right = forward.getClockWise();
                for (dx = 0; dx < 7; ++dx) {
                    for (int dz = 0; dz < 7; ++dz) {
                        positions.add(startPos.relative(forward, dx).relative(right, dz));
                    }
                }
            } else {
                Direction up = Direction.UP;
                Direction right = player.getDirection().getClockWise();
                for (dx = 0; dx < 7; ++dx) {
                    for (int dy = 0; dy < 7; ++dy) {
                        positions.add(startPos.relative(right, dx).relative(up, dy));
                    }
                }
            }
        }
        boolean placed = false;
        for (BlockPos targetPos : positions) {
            if (!level.isInWorldBounds(targetPos) || level.getBlockEntity(targetPos) != null || !level.getBlockState(targetPos).canBeReplaced() || !level.getEntities(null, new AABB(targetPos)).isEmpty()) continue;
            Vec3 hitVec = Vec3.atCenterOf((Vec3i)targetPos);
            BlockState placeState = blockToPlace.getStateForPlacement(new BlockPlaceContext(player, context.getHand(), stack, new BlockHitResult(hitVec, face, targetPos, false)));
            if (placeState == null) {
                placeState = newState;
            }
            level.setBlockAndUpdate(targetPos, placeState);
            placed = true;
        }
        if (placed) {
            level.playSound(null, pos, blockToPlace.getSoundType(newState, (LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
        MutableComponent modeText = switch (mode) {
            case 0 -> Component.literal((String)"Current Mode: Single Block");
            case 1 -> Component.literal((String)"Current Mode: Line (7 blocks)");
            case 2 -> Component.literal((String)"Current Mode: Platform (7x7)");
            default -> Component.literal((String)"Current Mode: Unknown");
        };
        tooltip.add((Component)modeText);
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

