/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.block.custom.LightPanelBlock;
import net.ricmc.betterblockz.block.custom.WallOrFloorLightBlock;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class CheckeredSpadeItem
extends Item {
    private static final Map<Block, Block> DIRT_MAP;
    private static final Map<Block, Block> STONE_MAP;
    private static final Map<Block, Block> REVERSE_DIRT_MAP;
    private static final Map<Block, Block> REVERSE_STONE_MAP;

    public CheckeredSpadeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos startPos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(1);
        Block clickedBlock = level.getBlockState(startPos).getBlock();
        Map<Block, Block> conversionMap = this.getMapForBlock(clickedBlock);
        if (!level.isClientSide()) {
            if (conversionMap != null) {
                Block replacement = conversionMap.get(clickedBlock);
                if (replacement == null) {
                    return InteractionResult.PASS;
                }
                this.applyMode(level, startPos, clickedBlock, mode, context.getClickedFace(), pos -> this.setBlock(level, (BlockPos)pos, replacement, clickedBlock, context.getClickedFace()), context.getPlayer());
            } else {
                this.applyMode(level, startPos, clickedBlock, mode, context.getClickedFace(), pos -> this.switchBlockVariant(level, (BlockPos)pos, context.getPlayer().isShiftKeyDown()), context.getPlayer());
            }
            level.playSound(null, startPos, (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.BLOCKS, 1.0f, 1.5f);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyMode(Level level, BlockPos startPos, Block clickedBlock, int mode, Direction face, Consumer<BlockPos> replacer, Player player) {
        switch (mode) {
            case 1: 
            case 2: {
                int lineLength = mode == 1 ? 7 : 21;
                Direction lineDir = Direction.NORTH;
                if (player != null) {
                    lineDir = face.getAxis().isHorizontal() ? (player.getViewXRot(1.0f) < -30.0f ? Direction.UP : (player.getViewXRot(1.0f) > 30.0f ? Direction.DOWN : player.getDirection().getCounterClockWise())) : player.getDirection();
                }
                for (int i = 0; i < lineLength; i += 2) {
                    BlockPos pos = startPos.relative(lineDir, i);
                    Block blockAtPos = level.getBlockState(pos).getBlock();
                    if (blockAtPos != clickedBlock) continue;
                    replacer.accept(pos);
                }
                break;
            }
            case 3: {
                this.floodFillCheckered(level, startPos, clickedBlock, face, replacer, 200);
                break;
            }
            case 4: {
                this.floodFillCheckered(level, startPos, clickedBlock, face, replacer, 800);
            }
        }
    }

    private void floodFillCheckered(Level level, BlockPos startPos, Block targetBlock, Direction face, Consumer<BlockPos> replacer, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        String baseName = this.getBaseName(targetBlock);
        List<BlockPos> offsets = face == Direction.UP || face == Direction.DOWN ? List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)) : (face.getAxis() == Direction.Axis.X ? List.of(new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)) : List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0)));
        int baseParity = startPos.getX() + startPos.getY() + startPos.getZ() & 1;
        while (!queue.isEmpty() && visited.size() < maxBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            Block blockAtPos = level.getBlockState(current).getBlock();
            if (!this.getBaseName(blockAtPos).equals(baseName)) continue;
            if (current.equals((Object)startPos) || (current.getX() + current.getY() + current.getZ() & 1) == baseParity) {
                replacer.accept(current);
            }
            for (BlockPos offset : offsets) {
                Block neighborBlock;
                BlockPos neighbor = current.offset((Vec3i)offset);
                if (visited.contains(neighbor) || !this.getBaseName(neighborBlock = level.getBlockState(neighbor).getBlock()).equals(baseName)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
    }

    private void setBlock(Level level, BlockPos pos, Block replacement, Block original, Direction face) {
        BlockState currentState = level.getBlockState(pos);
        BlockState newState = replacement.defaultBlockState();
        if (currentState.getBlock() instanceof WallOrFloorLightBlock && newState.hasProperty((Property)WallOrFloorLightBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)((Direction)currentState.getValue((Property)WallOrFloorLightBlock.FACING)));
        } else if (currentState.getBlock() instanceof LightPanelBlock && newState.hasProperty((Property)LightPanelBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)LightPanelBlock.FACING, (Comparable)((Direction)currentState.getValue((Property)LightPanelBlock.FACING)));
        } else {
            for (Property prop : currentState.getProperties()) {
                if (!prop.getName().equals("facing") || !newState.hasProperty(prop)) continue;
                newState = (BlockState)newState.setValue((Property)((DirectionProperty)prop), (Comparable)((Direction)currentState.getValue((Property)((DirectionProperty)prop))));
            }
        }
        level.setBlockAndUpdate(pos, newState);
    }

    private Map<Block, Block> getMapForBlock(Block block) {
        if (DIRT_MAP.containsKey(block)) {
            return DIRT_MAP;
        }
        if (STONE_MAP.containsKey(block)) {
            return STONE_MAP;
        }
        if (REVERSE_DIRT_MAP.containsKey(block)) {
            return REVERSE_DIRT_MAP;
        }
        if (REVERSE_STONE_MAP.containsKey(block)) {
            return REVERSE_STONE_MAP;
        }
        return null;
    }

    private void switchBlockVariant(Level level, BlockPos pos, boolean sneak) {
        Player player;
        BlockState currentState = level.getBlockState(pos);
        Block clickedBlock = currentState.getBlock();
        List variants = ModBlocks.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get()).filter(b -> this.getBaseName((Block)b).equals(this.getBaseName(clickedBlock))).sorted(Comparator.comparingInt(this::extractIndex)).collect(Collectors.toList());
        if (variants.size() <= 1) {
            return;
        }
        int index = variants.indexOf(clickedBlock);
        int nextIndex = sneak ? (index - 1 + variants.size()) % variants.size() : (index + 1) % variants.size();
        Block nextBlock = (Block)variants.get(nextIndex);
        BlockState newState = nextBlock.defaultBlockState();
        if (currentState.getBlock() instanceof WallOrFloorLightBlock && newState.hasProperty((Property)WallOrFloorLightBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)((Direction)currentState.getValue((Property)WallOrFloorLightBlock.FACING)));
        } else if (currentState.getBlock() instanceof LightPanelBlock && newState.hasProperty((Property)LightPanelBlock.FACING)) {
            newState = (BlockState)newState.setValue((Property)LightPanelBlock.FACING, (Comparable)((Direction)currentState.getValue((Property)LightPanelBlock.FACING)));
        } else {
            for (Property prop : currentState.getProperties()) {
                if (!prop.getName().equals("facing") || !newState.hasProperty(prop)) continue;
                newState = (BlockState)newState.setValue((Property)((DirectionProperty)prop), (Comparable)((Direction)currentState.getValue((Property)((DirectionProperty)prop))));
            }
        }
        level.setBlockAndUpdate(pos, newState);
        if (!level.isClientSide() && (player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0, false)) != null) {
            String displayName = Component.translatable((String)nextBlock.getDescriptionId()).getString();
            player.displayClientMessage((Component)Component.literal((String)("\u2192 " + displayName)), true);
        }
    }

    private String getBaseName(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        String path = key.getPath();
        int underscore = path.lastIndexOf("_");
        return underscore != -1 ? path.substring(0, underscore) : path;
    }

    private int extractIndex(Block block) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        int underscore = path.lastIndexOf("_");
        if (underscore != -1) {
            try {
                return Integer.parseInt(path.substring(underscore + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            int currentMode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(1);
            int nextMode = currentMode % 4 + 1;
            stack.set(ModDataComponents.BUILDER_MODE, (Object)nextMode);
            String msg = switch (nextMode) {
                case 1 -> "Line (7)";
                case 2 -> "Line (21)";
                case 3 -> "Area Small";
                case 4 -> "Area Large";
                default -> "";
            };
            player.displayClientMessage((Component)Component.literal((String)msg), true);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line3")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    static {
        HashMap<Block, Block> dirtMap = new HashMap<Block, Block>();
        dirtMap.put(Blocks.DIRT, (Block)ModBlocks.DIRT_BLOCKZ.get());
        dirtMap.put(Blocks.GRASS_BLOCK, (Block)ModBlocks.DIRT_BLOCKZ.get());
        dirtMap.put(Blocks.DIRT_PATH, (Block)ModBlocks.DIRT_BLOCKZ.get());
        dirtMap.put(Blocks.COARSE_DIRT, (Block)ModBlocks.DIRT_BLOCKZ.get());
        DIRT_MAP = Collections.unmodifiableMap(dirtMap);
        HashMap<Block, Block> stoneMap = new HashMap<Block, Block>();
        stoneMap.put(Blocks.STONE, (Block)ModBlocks.STONE_BLOCKZ.get());
        stoneMap.put(Blocks.COBBLESTONE, (Block)ModBlocks.STONE_BLOCKZ.get());
        stoneMap.put(Blocks.ANDESITE, (Block)ModBlocks.STONE_BLOCKZ.get());
        STONE_MAP = Collections.unmodifiableMap(stoneMap);
        REVERSE_DIRT_MAP = Map.of((Block)ModBlocks.DIRT_BLOCKZ.get(), Blocks.DIRT);
        REVERSE_STONE_MAP = Map.of((Block)ModBlocks.STONE_BLOCKZ.get(), Blocks.COBBLESTONE);
    }
}

