/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.ricmc.betterblockz.block.custom.FlatBarLightBlock;
import net.ricmc.betterblockz.block.custom.FlatBarLightVerticalBlock;
import net.ricmc.betterblockz.block.custom.LightPanelBlock;
import net.ricmc.betterblockz.block.custom.RotatableBlock;
import net.ricmc.betterblockz.block.custom.WallOrFloorLightBlock;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class AutoPlacerItem
extends Item {
    private final Map<PlayerHandKey, List<Pair<BlockPos, BlockState>>> lastPlaced = new HashMap<PlayerHandKey, List<Pair<BlockPos, BlockState>>>();

    public AutoPlacerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (player == null || level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Block clickedBlock = level.getBlockState(pos).getBlock();
        BlockState clickedState = level.getBlockState(pos);
        PlayerHandKey key = new PlayerHandKey(player.getUUID(), context.getHand());
        if (player.isShiftKeyDown()) {
            boolean clickedIsPlaced;
            boolean hasUndo = this.lastPlaced.containsKey(key) && !this.lastPlaced.get(key).isEmpty();
            boolean bl = clickedIsPlaced = hasUndo && this.lastPlaced.get(key).stream().anyMatch(pair -> ((BlockPos)pair.getFirst()).equals((Object)pos));
            if (clickedIsPlaced) {
                List<Pair<BlockPos, BlockState>> placedList = this.lastPlaced.get(key);
                int returned = 0;
                for (Pair<BlockPos, BlockState> pair2 : placedList) {
                    Block storedBlock;
                    level.setBlockAndUpdate(pair2.getFirst(), pair2.getSecond());
                    if (player.isCreative() || (storedBlock = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)stack.get(ModDataComponents.STORED_BLOCK))) == null || !pair2.getSecond().isAir()) continue;
                    ItemStack returnStack = new ItemStack((ItemLike)storedBlock);
                    if (!player.getInventory().add(returnStack)) {
                        player.drop(returnStack, false);
                    }
                    ++returned;
                }
                this.lastPlaced.remove(key);
                player.sendSystemMessage((Component)Component.literal((String)("Undid last placement!" + (String)(player.isCreative() ? " " : " Returned " + returned + " blocks."))));
                level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                stack.set(ModDataComponents.STORED_BLOCK, (Object)BuiltInRegistries.BLOCK.getKey((Object)clickedBlock));
                if (clickedBlock instanceof RotatedPillarBlock && clickedState.hasProperty((Property)RotatedPillarBlock.AXIS)) {
                    stack.set(ModDataComponents.STORED_AXIS, (Object)((Direction.Axis)clickedState.getValue((Property)RotatedPillarBlock.AXIS)).getName());
                } else {
                    stack.remove(ModDataComponents.STORED_AXIS);
                }
                if (clickedState.getProperties().stream().anyMatch(p -> p.getName().equals("facing"))) {
                    facing = (Direction)clickedState.getValue(clickedState.getProperties().stream().filter(p -> p.getName().equals("facing")).findFirst().get());
                    stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
                } else if (clickedState.getProperties().stream().anyMatch(p -> p.getName().equals("horizontal_facing"))) {
                    facing = (Direction)clickedState.getValue(clickedState.getProperties().stream().filter(p -> p.getName().equals("horizontal_facing")).findFirst().get());
                    stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
                } else {
                    stack.remove(ModDataComponents.STORED_FACING);
                }
                int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
                int size = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_SIZE)).orElse(3);
                Object modeName = mode == 0 ? "Area Mode " + (size == 3 ? "7x7" : "21x21") : (mode == 1 ? "Line Mode " + (size == 3 ? "7 blocks" : "21 blocks") : "Unknown Mode");
                player.displayClientMessage((Component)Component.literal((String)("Saved block type: " + clickedBlock.getName().getString() + " (" + (String)modeName + ")")), true);
                level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.CONSUME;
        }
        if (stack.get(ModDataComponents.STORED_BLOCK) == null) {
            player.displayClientMessage((Component)Component.literal((String)"No block saved! Sneak + right-click a block first."), true);
            return InteractionResult.FAIL;
        }
        Block blockToPlace = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)stack.get(ModDataComponents.STORED_BLOCK));
        if (blockToPlace == null) {
            return InteractionResult.FAIL;
        }
        if (!player.isCreative() && this.countBlocksInInventory(player, blockToPlace) == 0) {
            player.displayClientMessage((Component)Component.literal((String)("You don't have any " + blockToPlace.getName().getString() + " in your inventory!")), true);
            return InteractionResult.FAIL;
        }
        int radius = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_SIZE)).orElse(3);
        int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
        ArrayList<BlockPos> emptyPositions = new ArrayList<BlockPos>();
        if (mode == 0) {
            if (face == Direction.UP || face == Direction.DOWN) {
                Direction forward = player.getDirection();
                Direction right = forward.getClockWise();
                int height = face == Direction.UP ? 1 : -1;
                for (dx = 0; dx < radius * 2 + 1; ++dx) {
                    for (int dz = 0; dz < radius * 2 + 1; ++dz) {
                        offsetPos = pos.relative(right, dx).relative(forward, dz).above(height);
                        if (!level.isEmptyBlock(offsetPos)) continue;
                        emptyPositions.add(offsetPos);
                    }
                }
            } else {
                Direction widthDir = face.getCounterClockWise();
                Direction heightDir = Direction.UP;
                BlockPos startPos = pos.relative(face);
                for (dx = 0; dx < radius * 2 + 1; ++dx) {
                    for (int dy = 0; dy < radius * 2 + 1; ++dy) {
                        offsetPos = startPos.relative(widthDir, dx).relative(heightDir, dy);
                        if (!level.isEmptyBlock(offsetPos)) continue;
                        emptyPositions.add(offsetPos);
                    }
                }
            }
        } else if (mode == 1) {
            int length = radius == 3 ? 7 : 21;
            BlockPos startPos = pos.relative(face);
            Direction lineDir = face.getAxis().isHorizontal() ? (player.getViewXRot(1.0f) < -30.0f ? Direction.UP : (player.getViewXRot(1.0f) > 30.0f ? Direction.DOWN : player.getDirection().getCounterClockWise())) : player.getDirection();
            for (int i = 0; i < length; ++i) {
                BlockPos offsetPos = startPos.relative(lineDir, i);
                if (!level.isEmptyBlock(offsetPos)) continue;
                emptyPositions.add(offsetPos);
            }
        }
        ArrayList<Pair<BlockPos, BlockState>> placed = new ArrayList<Pair<BlockPos, BlockState>>();
        for (BlockPos targetPos : emptyPositions) {
            String storedFacing;
            if (!player.isCreative() && !this.removeBlockFromInventory(player, blockToPlace)) continue;
            BlockState previous = level.getBlockState(targetPos);
            Direction targetFace = face;
            Vec3 hitVec = Vec3.atCenterOf((Vec3i)targetPos);
            BlockState newState = blockToPlace.getStateForPlacement(new BlockPlaceContext(player, context.getHand(), stack, new BlockHitResult(hitVec, targetFace, targetPos, false)));
            if (newState == null) {
                newState = blockToPlace.defaultBlockState();
            }
            if (blockToPlace instanceof WallOrFloorLightBlock) {
                WallOrFloorLightBlock wf = (WallOrFloorLightBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            } else if (blockToPlace instanceof LightPanelBlock) {
                LightPanelBlock lp = (LightPanelBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)LightPanelBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)LightPanelBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            } else if (blockToPlace instanceof FlatBarLightBlock) {
                FlatBarLightBlock lp = (FlatBarLightBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)FlatBarLightBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)FlatBarLightBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            } else if (blockToPlace instanceof FlatBarLightVerticalBlock) {
                FlatBarLightVerticalBlock lp = (FlatBarLightVerticalBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)FlatBarLightVerticalBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)FlatBarLightVerticalBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            }
            if (blockToPlace instanceof RotatedPillarBlock) {
                String storedAxis = (String)stack.get(ModDataComponents.STORED_AXIS);
                if (storedAxis != null) {
                    try {
                        newState = (BlockState)newState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.byName((String)storedAxis));
                    }
                    catch (Exception lp) {}
                } else if (clickedBlock instanceof RotatedPillarBlock) {
                    newState = (BlockState)newState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)clickedState.getValue((Property)RotatedPillarBlock.AXIS)));
                }
            }
            if (blockToPlace instanceof RotatableBlock && (storedFacing = (String)stack.get(ModDataComponents.STORED_FACING)) != null) {
                try {
                    Direction dir = Direction.byName((String)storedFacing);
                    if (dir != null && newState.hasProperty((Property)RotatableBlock.FACING)) {
                        newState = (BlockState)newState.setValue((Property)RotatableBlock.FACING, (Comparable)dir);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            level.setBlockAndUpdate(targetPos, newState);
            placed.add(new Pair<BlockPos, BlockState>(targetPos, previous));
        }
        if (!placed.isEmpty()) {
            this.lastPlaced.put(new PlayerHandKey(player.getUUID(), context.getHand()), placed);
            level.playSound(null, pos, blockToPlace.getSoundType(blockToPlace.defaultBlockState(), (LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            int nextMode;
            int nextSize;
            int currentSize = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_SIZE)).orElse(3);
            int currentMode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
            if (currentMode == 0 && currentSize == 3) {
                nextSize = 10;
                nextMode = 0;
            } else if (currentMode == 0 && currentSize == 10) {
                nextSize = 3;
                nextMode = 1;
            } else if (currentMode == 1 && currentSize == 3) {
                nextSize = 10;
                nextMode = 1;
            } else {
                nextSize = 3;
                nextMode = 0;
            }
            stack.set(ModDataComponents.BUILDER_SIZE, (Object)nextSize);
            stack.set(ModDataComponents.BUILDER_MODE, (Object)nextMode);
            String msg = nextMode == 0 ? (nextSize == 3 ? "Area mode: 7x7" : "Area mode: 21x21") : (nextSize == 3 ? "Line mode: 7 blocks" : "Line mode: 21 blocks");
            player.displayClientMessage((Component)Component.literal((String)msg), true);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private int countBlocksInInventory(Player player, Block block) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is(block.asItem())) continue;
            count += stack.getCount();
        }
        return count;
    }

    private boolean removeBlockFromInventory(Player player, Block block) {
        if (player.isCreative()) {
            return true;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is(block.asItem())) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line3")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line4")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    private record PlayerHandKey(UUID playerId, InteractionHand hand) {
    }

    private static class Pair<A, B> {
        private final A first;
        private final B second;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            return this.first;
        }

        public B getSecond() {
            return this.second;
        }
    }
}

