/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class GlowingPillarBlock
extends RotatedPillarBlock {
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");

    public GlowingPillarBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> state.hasProperty((Property)LIT) && (Boolean)state.getValue((Property)LIT) != false ? 15 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    public void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide && state.hasProperty((Property)LIT)) {
            boolean powered = level.hasNeighborSignal(pos);
            boolean lit = (Boolean)state.getValue((Property)LIT);
            if (powered && lit) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1.0f;
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return false;
    }
}

