/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.event;

import com.breakinblocks.beer.Config;
import com.breakinblocks.beer.data.EnchantingTableRangeData;
import com.breakinblocks.beer.network.NetworkHandler;
import com.breakinblocks.beer.network.SyncEnchantingDataPacket;
import com.breakinblocks.beer.util.EnchantingTableDataUtil;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class EnchantingTablePersistenceHandler {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        CompoundTag beerData;
        if (!Config.enableItemModifiers) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        if (!event.getPlacedBlock().is(Blocks.ENCHANTING_TABLE)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.getMainHandItem();
        if (!stack.is(Blocks.ENCHANTING_TABLE.asItem()) && !(stack = player.getOffhandItem()).is(Blocks.ENCHANTING_TABLE.asItem())) {
            return;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && ((beerData = customData.copyTag()).contains("ItemModifiersX") || beerData.contains("ItemModifiersY") || beerData.contains("ItemModifiersZ"))) {
            int modX = beerData.getInt("ItemModifiersX");
            int modY = beerData.getInt("ItemModifiersY");
            int modZ = beerData.getInt("ItemModifiersZ");
            level.getServer().execute(() -> {
                EnchantingTableDataUtil.setRanges((Level)level, pos, modX, modY, modZ);
                EnchantingTableRangeData restoredData = EnchantingTableDataUtil.getRangeData((Level)level, pos);
                SyncEnchantingDataPacket syncPacket = SyncEnchantingDataPacket.create(pos, restoredData);
                NetworkHandler.sendToAllPlayers(syncPacket);
            });
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!Config.enableItemModifiers) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        if (!event.getState().is(Blocks.ENCHANTING_TABLE)) {
            return;
        }
        EnchantingTableRangeData data = EnchantingTableDataUtil.getRangeData((Level)level, pos);
        if (!data.hasItemModifications()) {
            return;
        }
        event.setCanceled(true);
        level.removeBlock(pos, false);
        ItemStack enchantingTableStack = new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE);
        CompoundTag beerData = new CompoundTag();
        beerData.putInt("ItemModifiersX", data.getItemModifiersX());
        beerData.putInt("ItemModifiersY", data.getItemModifiersY());
        beerData.putInt("ItemModifiersZ", data.getItemModifiersZ());
        CustomData customData = CustomData.of((CompoundTag)beerData);
        enchantingTableStack.set(DataComponents.CUSTOM_DATA, (Object)customData);
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        lore.add(Component.literal((String)"Bookshelf Range Modifiers:").withStyle(ChatFormatting.GRAY));
        MutableComponent modifierLine = Component.empty();
        boolean hasModifiers = false;
        if (data.getItemModifiersX() != 0) {
            if (hasModifiers) {
                modifierLine = modifierLine.append(" ");
            }
            modifierLine = modifierLine.append((Component)Component.literal((String)("X: " + (data.getItemModifiersX() > 0 ? "+" : "") + data.getItemModifiersX())).withStyle(ChatFormatting.RED));
            hasModifiers = true;
        }
        if (data.getItemModifiersY() != 0) {
            if (hasModifiers) {
                modifierLine = modifierLine.append(" ");
            }
            modifierLine = modifierLine.append((Component)Component.literal((String)("Y: " + (data.getItemModifiersY() > 0 ? "+" : "") + data.getItemModifiersY())).withStyle(ChatFormatting.GREEN));
            hasModifiers = true;
        }
        if (data.getItemModifiersZ() != 0) {
            if (hasModifiers) {
                modifierLine = modifierLine.append(" ");
            }
            modifierLine = modifierLine.append((Component)Component.literal((String)("Z: " + (data.getItemModifiersZ() > 0 ? "+" : "") + data.getItemModifiersZ())).withStyle(ChatFormatting.BLUE));
        }
        lore.add(modifierLine);
        enchantingTableStack.set(DataComponents.LORE, (Object)new ItemLore(lore));
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        ItemEntity itemEntity = new ItemEntity((Level)level, x, y, z, enchantingTableStack);
        level.addFreshEntity((Entity)itemEntity);
        event.getState().getBlock().popExperience(level, pos, 0);
    }
}

