/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.data;

import com.breakinblocks.beer.Config;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class EnchantingTableRangeData
implements INBTSerializable<CompoundTag> {
    private int itemModifiersX;
    private int itemModifiersY;
    private int itemModifiersZ;

    public EnchantingTableRangeData() {
        this.itemModifiersX = 0;
        this.itemModifiersY = 0;
        this.itemModifiersZ = 0;
    }

    public EnchantingTableRangeData(int rangeX, int rangeY, int rangeZ) {
        this.itemModifiersX = rangeX;
        this.itemModifiersY = rangeY;
        this.itemModifiersZ = rangeZ;
    }

    public int getItemModifiersX() {
        return this.itemModifiersX;
    }

    public int getItemModifiersY() {
        return this.itemModifiersY;
    }

    public int getItemModifiersZ() {
        return this.itemModifiersZ;
    }

    public int getEffectiveRangeX() {
        return Math.max(0, 2 + this.itemModifiersX);
    }

    public int getEffectiveRangeY() {
        return Math.max(0, 1 + this.itemModifiersY);
    }

    public int getEffectiveRangeZ() {
        return Math.max(0, 2 + this.itemModifiersZ);
    }

    public void addItemModifierX(int amount) {
        this.itemModifiersX = this.clampItemModifierX(this.itemModifiersX + amount);
    }

    public void addItemModifierY(int amount) {
        this.itemModifiersY = this.clampItemModifierY(this.itemModifiersY + amount);
    }

    public void addItemModifierZ(int amount) {
        this.itemModifiersZ = this.clampItemModifierZ(this.itemModifiersZ + amount);
    }

    public void setItemModifierX(int modifier) {
        this.itemModifiersX = this.clampItemModifierX(modifier);
    }

    public void setItemModifierY(int modifier) {
        this.itemModifiersY = this.clampItemModifierY(modifier);
    }

    public void setItemModifierZ(int modifier) {
        this.itemModifiersZ = this.clampItemModifierZ(modifier);
    }

    private int clampItemModifierX(int modifier) {
        return Math.max(-2, Math.min(modifier, Config.maxItemModifiersPerAxis));
    }

    private int clampItemModifierY(int modifier) {
        return Math.max(-1, Math.min(modifier, Config.maxItemModifiersPerAxis));
    }

    private int clampItemModifierZ(int modifier) {
        return Math.max(-2, Math.min(modifier, Config.maxItemModifiersPerAxis));
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("itemModifiersX", this.itemModifiersX);
        tag.putInt("itemModifiersY", this.itemModifiersY);
        tag.putInt("itemModifiersZ", this.itemModifiersZ);
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag tag) {
        this.itemModifiersX = this.clampItemModifierX(tag.getInt("itemModifiersX"));
        this.itemModifiersY = this.clampItemModifierY(tag.getInt("itemModifiersY"));
        this.itemModifiersZ = this.clampItemModifierZ(tag.getInt("itemModifiersZ"));
    }

    public boolean hasItemModifications() {
        return this.itemModifiersX != 0 || this.itemModifiersY != 0 || this.itemModifiersZ != 0;
    }

    public void resetToDefaults() {
        this.itemModifiersX = 0;
        this.itemModifiersY = 0;
        this.itemModifiersZ = 0;
    }
}

