/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.codecs.DocValuesProducer;
import org.apache.lucene.ars_nouveau.codecs.FieldsProducer;
import org.apache.lucene.ars_nouveau.codecs.KnnVectorsReader;
import org.apache.lucene.ars_nouveau.codecs.NormsProducer;
import org.apache.lucene.ars_nouveau.codecs.PointsReader;
import org.apache.lucene.ars_nouveau.codecs.StoredFieldsReader;
import org.apache.lucene.ars_nouveau.codecs.TermVectorsReader;
import org.apache.lucene.ars_nouveau.index.BinaryDocValues;
import org.apache.lucene.ars_nouveau.index.ByteVectorValues;
import org.apache.lucene.ars_nouveau.index.DocValuesSkipIndexType;
import org.apache.lucene.ars_nouveau.index.DocValuesSkipper;
import org.apache.lucene.ars_nouveau.index.DocValuesType;
import org.apache.lucene.ars_nouveau.index.FieldInfo;
import org.apache.lucene.ars_nouveau.index.FloatVectorValues;
import org.apache.lucene.ars_nouveau.index.IndexOptions;
import org.apache.lucene.ars_nouveau.index.LeafReader;
import org.apache.lucene.ars_nouveau.index.NumericDocValues;
import org.apache.lucene.ars_nouveau.index.PointValues;
import org.apache.lucene.ars_nouveau.index.SortedDocValues;
import org.apache.lucene.ars_nouveau.index.SortedNumericDocValues;
import org.apache.lucene.ars_nouveau.index.SortedSetDocValues;
import org.apache.lucene.ars_nouveau.index.StoredFieldVisitor;
import org.apache.lucene.ars_nouveau.index.StoredFields;
import org.apache.lucene.ars_nouveau.index.TermVectors;
import org.apache.lucene.ars_nouveau.index.Terms;
import org.apache.lucene.ars_nouveau.index.VectorEncoding;
import org.apache.lucene.ars_nouveau.search.KnnCollector;
import org.apache.lucene.ars_nouveau.util.Bits;

public abstract class CodecReader
extends LeafReader {
    protected CodecReader() {
    }

    public abstract StoredFieldsReader getFieldsReader();

    public abstract TermVectorsReader getTermVectorsReader();

    public abstract NormsProducer getNormsReader();

    public abstract DocValuesProducer getDocValuesReader();

    public abstract FieldsProducer getPostingsReader();

    public abstract PointsReader getPointsReader();

    public abstract KnnVectorsReader getVectorReader();

    @Override
    public final StoredFields storedFields() throws IOException {
        final StoredFieldsReader reader = this.getFieldsReader();
        return new StoredFields(){

            @Override
            public void prefetch(int docID) throws IOException {
                Objects.checkIndex(docID, CodecReader.this.maxDoc());
                reader.prefetch(docID);
            }

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                Objects.checkIndex(docID, CodecReader.this.maxDoc());
                reader.document(docID, visitor);
            }
        };
    }

    @Override
    public final TermVectors termVectors() throws IOException {
        TermVectorsReader reader = this.getTermVectorsReader();
        if (reader == null) {
            return TermVectors.EMPTY;
        }
        return reader;
    }

    @Override
    public final Terms terms(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getIndexOptions() == IndexOptions.NONE) {
            return null;
        }
        return this.getPostingsReader().terms(field);
    }

    private FieldInfo getDVField(String field, DocValuesType type) {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public final NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getNumeric(fi);
    }

    @Override
    public final BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getBinary(fi);
    }

    @Override
    public final SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSorted(fi);
    }

    @Override
    public final SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedNumeric(fi);
    }

    @Override
    public final SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedSet(fi);
    }

    @Override
    public final DocValuesSkipper getDocValuesSkipper(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.docValuesSkipIndexType() == DocValuesSkipIndexType.NONE) {
            return null;
        }
        return this.getDocValuesReader().getSkipper(fi);
    }

    @Override
    public final NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.getNormsReader().getNorms(fi);
    }

    @Override
    public final PointValues getPointValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getPointDimensionCount() == 0) {
            return null;
        }
        return this.getPointsReader().getValues(field);
    }

    @Override
    public final FloatVectorValues getFloatVectorValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return null;
        }
        return this.getVectorReader().getFloatVectorValues(field);
    }

    @Override
    public final ByteVectorValues getByteVectorValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return null;
        }
        return this.getVectorReader().getByteVectorValues(field);
    }

    @Override
    public final void searchNearestVectors(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return;
        }
        this.getVectorReader().search(field, target, knnCollector, acceptDocs);
    }

    @Override
    public final void searchNearestVectors(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getVectorDimension() == 0 || fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return;
        }
        this.getVectorReader().search(field, target, knnCollector, acceptDocs);
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        if (this.getPostingsReader() != null) {
            this.getPostingsReader().checkIntegrity();
        }
        if (this.getNormsReader() != null) {
            this.getNormsReader().checkIntegrity();
        }
        if (this.getDocValuesReader() != null) {
            this.getDocValuesReader().checkIntegrity();
        }
        if (this.getFieldsReader() != null) {
            this.getFieldsReader().checkIntegrity();
        }
        if (this.getTermVectorsReader() != null) {
            this.getTermVectorsReader().checkIntegrity();
        }
        if (this.getPointsReader() != null) {
            this.getPointsReader().checkIntegrity();
        }
        if (this.getVectorReader() != null) {
            this.getVectorReader().checkIntegrity();
        }
    }
}

