/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.rewind;

import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.event.timed.IRewindable;
import com.hollingsworth.arsnouveau.common.event.timed.RewindEvent;
import com.hollingsworth.arsnouveau.common.spell.rewind.IRewindCallback;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindEntityData;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

public class EntityToBlockRewind
implements IRewindCallback {
    public BlockPos pos;
    public BlockState state;
    EnchantedFallingBlock previousEntity;
    Stack<RewindEntityData> data;

    public EntityToBlockRewind(EnchantedFallingBlock previousEntity, BlockPos pos, BlockState state) {
        this.pos = pos;
        this.state = state;
        this.previousEntity = previousEntity;
        if (previousEntity instanceof IRewindable) {
            IRewindable rewindable = (IRewindable)((Object)previousEntity);
            this.data = rewindable.getMotions();
        }
    }

    @Override
    public void onRewind(RewindEvent event) {
        if (this.state != this.previousEntity.level.getBlockState(this.pos)) {
            return;
        }
        event.entity = EnchantedFallingBlock.fall(this.previousEntity.level, this.pos, this.previousEntity.getOwner(), this.previousEntity.context, this.previousEntity.resolver, this.previousEntity.spellStats);
        Entity entity = event.entity;
        if (entity instanceof EnchantedFallingBlock) {
            EnchantedFallingBlock enchantedFallingBlock = (EnchantedFallingBlock)entity;
            enchantedFallingBlock.context = event.context;
        }
        if ((entity = event.entity) instanceof IRewindable) {
            IRewindable rewindable = (IRewindable)entity;
            rewindable.setRewinding(true);
            if (this.data != null) {
                rewindable.getMotions().addAll(this.data);
            }
            if (!rewindable.getMotions().isEmpty()) {
                RewindEntityData data = rewindable.getMotions().pop();
                data.onRewind(event);
            }
        }
    }
}

