/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarDrygmy;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWhirlisprig;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import com.hollingsworth.arsnouveau.common.items.AnimModItem;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;

public class StarbuncleShades
extends AnimModItem
implements ICosmeticItem {
    public static final Vec3 starbyTrans = new Vec3(0.0, -0.259, 0.165);
    public static final Vec3 starbyScale = new Vec3(1.0, 1.0, 1.0);

    public StarbuncleShades() {
        this.withTooltip((Component)Component.translatable((String)"tooltip.starbuncle_shades"));
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        if (pInteractionTarget instanceof IDecoratable) {
            IDecoratable starbuncle = (IDecoratable)pInteractionTarget;
            if (this.canWear(pInteractionTarget)) {
                starbuncle.setCosmeticItem(pStack.split(1));
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactLivingEntity(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    @Override
    public boolean canWear(LivingEntity entity) {
        return entity instanceof Starbuncle || entity instanceof FamiliarEntity;
    }

    @Override
    public Vec3 getTranslations(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FamiliarBookwyrm.class, FamiliarWixie.class, FamiliarDrygmy.class, FamiliarWhirlisprig.class}, (Object)livingEntity, n)) {
            case 0 -> {
                FamiliarBookwyrm ignored = (FamiliarBookwyrm)livingEntity;
                yield new Vec3(0.0, -0.235, 0.095);
            }
            case 1 -> {
                FamiliarWixie ignored = (FamiliarWixie)livingEntity;
                yield new Vec3(0.0, -0.15, 0.26);
            }
            case 2 -> {
                FamiliarDrygmy ignored = (FamiliarDrygmy)livingEntity;
                yield new Vec3(0.0, -0.13, 0.275);
            }
            case 3 -> {
                FamiliarWhirlisprig ignored = (FamiliarWhirlisprig)livingEntity;
                yield new Vec3(0.0, -0.175, 0.275);
            }
            default -> starbyTrans;
        };
    }

    @Override
    public Vec3 getScaling(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FamiliarBookwyrm.class, FamiliarWixie.class, FamiliarDrygmy.class, FamiliarWhirlisprig.class}, (Object)livingEntity, n)) {
            case 0 -> {
                FamiliarBookwyrm ignored = (FamiliarBookwyrm)livingEntity;
                yield defaultScaling;
            }
            case 1 -> {
                FamiliarWixie ignored = (FamiliarWixie)livingEntity;
                yield new Vec3(1.0, 1.0, 1.0);
            }
            case 2 -> {
                FamiliarDrygmy ignored = (FamiliarDrygmy)livingEntity;
                yield defaultScaling.scale(1.125);
            }
            case 3 -> {
                FamiliarWhirlisprig ignored = (FamiliarWhirlisprig)livingEntity;
                yield defaultScaling.scale(1.125);
            }
            default -> starbyScale;
        };
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private final BlockEntityWithoutLevelRenderer renderer = new GenericItemRenderer(new GenericModel<AnimModItem>("starbuncle_shades", "item")).withTranslucency();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }
}

