/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.crafting.recipes.DispelEntityRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.setup.registry.EntitySubPredicatesRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public class DispelEntityProvider
extends SimpleDataProvider {
    public List<Wrapper> recipes = new ArrayList<Wrapper>();

    public DispelEntityProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (Wrapper recipe : this.recipes) {
            Path path = DispelEntityProvider.getRecipePath(this.output, recipe.location().getPath());
            this.saveStable(pOutput, (JsonElement)DispelEntityRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe.recipe).getOrThrow(), path);
        }
    }

    protected void addEntries() {
        this.recipes.add(new Wrapper(ArsNouveau.prefix("blaze_powder"), new DispelEntityRecipe(EntityType.BLAZE, EntityType.BLAZE.getDefaultLootTable().location(), new LootItemCondition[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)))).build()})));
        this.recipes.add(new Wrapper(ArsNouveau.prefix("wixie_shard"), new DispelEntityRecipe(EntityType.WITCH, ArsNouveau.prefix("dispel_witch"), new LootItemCondition[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new EntitySubPredicatesRegistry.PercentHealthEqualOrLowerPredicate(0.5f))).build()})));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipe/dispel_entity/" + id + ".json");
    }

    public String getName() {
        return "Dispel Entity Datagen";
    }

    public record Wrapper(ResourceLocation location, DispelEntityRecipe recipe) {
    }
}

