/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.timelines;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.BurstMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.TrailMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ModelProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.MotionProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.BaseTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineOption;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ProjectileTimeline
extends BaseTimeline<ProjectileTimeline> {
    public static final MapCodec<ProjectileTimeline> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TimelineEntryData.CODEC.fieldOf("trailEffect").forGetter(i -> i.trailEffect), (App)TimelineEntryData.CODEC.fieldOf("onResolvingEffect").forGetter(i -> i.onResolvingEffect), (App)TimelineEntryData.CODEC.fieldOf("onSpawnEffect").forGetter(i -> i.onSpawnEffect), (App)TimelineEntryData.CODEC.fieldOf("flairEffect").forGetter(i -> i.flairEffect), (App)SoundProperty.CODEC.fieldOf("castSound").forGetter(i -> i.castSound), (App)SoundProperty.CODEC.fieldOf("resolveSound").forGetter(i -> i.resolveSound)).apply((Applicative)instance, ProjectileTimeline::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProjectileTimeline> STREAM_CODEC = StreamCodec.composite(TimelineEntryData.STREAM, ProjectileTimeline::trailEffect, TimelineEntryData.STREAM, ProjectileTimeline::onResolvingEffect, TimelineEntryData.STREAM, ProjectileTimeline::onSpawnEffect, TimelineEntryData.STREAM, ProjectileTimeline::flairEffect, SoundProperty.STREAM_CODEC, i -> i.castSound, SoundProperty.STREAM_CODEC, i -> i.resolveSound, ProjectileTimeline::new);
    public static final List<IParticleMotionType<?>> TRAIL_OPTIONS = new CopyOnWriteArrayList();
    public static final List<IParticleMotionType<?>> RESOLVING_OPTIONS = new CopyOnWriteArrayList();
    public static final List<IParticleMotionType<?>> SPAWN_OPTIONS = new CopyOnWriteArrayList();
    public static final List<IParticleMotionType<?>> FLAIR_OPTIONS = new CopyOnWriteArrayList();
    public TimelineEntryData onSpawnEffect;
    public TimelineEntryData trailEffect;
    public TimelineEntryData onResolvingEffect;
    public TimelineEntryData flairEffect;
    public SoundProperty castSound = new SoundProperty();
    public SoundProperty resolveSound = new SoundProperty();

    public ProjectileTimeline() {
        this(new TimelineEntryData((ParticleMotion)new TrailMotion(), new PropertyParticleOptions()), new TimelineEntryData((ParticleMotion)new BurstMotion(), new PropertyParticleOptions()), new TimelineEntryData(), new TimelineEntryData(), new SoundProperty(), new SoundProperty());
    }

    public ProjectileTimeline(TimelineEntryData trailEffect, TimelineEntryData onResolvingEffect, TimelineEntryData onSpawnEffect, TimelineEntryData flairEffect, SoundProperty castSound, SoundProperty resolveSound) {
        this.trailEffect = trailEffect;
        this.onResolvingEffect = onResolvingEffect;
        this.onSpawnEffect = onSpawnEffect;
        this.flairEffect = flairEffect;
        this.castSound = castSound;
        this.resolveSound = resolveSound;
    }

    public TimelineEntryData trailEffect() {
        return this.trailEffect;
    }

    public TimelineEntryData onResolvingEffect() {
        return this.onResolvingEffect;
    }

    public TimelineEntryData onSpawnEffect() {
        return this.onSpawnEffect;
    }

    public TimelineEntryData flairEffect() {
        return this.flairEffect;
    }

    @Override
    public IParticleTimelineType<ProjectileTimeline> getType() {
        return (IParticleTimelineType)ParticleTimelineRegistry.PROJECTILE_TIMELINE.get();
    }

    @Override
    public List<BaseProperty<?>> getProperties() {
        return List.of(this.trailEffect.motion().propertyMap.createIfMissing(new ModelProperty()), new MotionProperty(new TimelineOption(TimelineOption.SPAWN, this.onSpawnEffect, ImmutableList.copyOf(SPAWN_OPTIONS)), List.of(this.castSound)), new MotionProperty(new TimelineOption(TimelineOption.TRAIL, this.trailEffect, ImmutableList.copyOf(TRAIL_OPTIONS))), new MotionProperty(new TimelineOption(TimelineOption.IMPACT, this.onResolvingEffect, ImmutableList.copyOf(RESOLVING_OPTIONS)), List.of(this.resolveSound)), new MotionProperty(new TimelineOption(TimelineOption.FLAIR, this.flairEffect, ImmutableList.copyOf(FLAIR_OPTIONS))));
    }
}

