/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.familiars;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.MermaidEntity;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MermaidFamiliar
extends FlyingFamiliarEntity
implements ISpellCastListener {
    RawAnimation swim = RawAnimation.begin().thenLoop("swim");
    RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    RawAnimation ground = RawAnimation.begin().thenLoop("ground");
    RawAnimation floating = RawAnimation.begin().thenLoop("floating");

    public MermaidFamiliar(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
    }

    public MermaidFamiliar(Level level) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.SIREN_FAMILIAR.get()), level);
    }

    public boolean canDrownInFluidType(@NotNull FluidType type) {
        return false;
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player pPlayer, @NotNull Vec3 pVec, @NotNull InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || pPlayer.getCommandSenderWorld().isClientSide) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.getItemInHand(hand);
        String color = MermaidEntity.Variants.getColorFromStack(stack);
        if (color != null && !this.getColor().equals(color)) {
            this.setColor(color);
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(pPlayer, pVec, hand);
    }

    public void onModifier(SpellModifierEvent event) {
        if (this.isAlive() && this.getOwner() != null && this.getOwner().equals((Object)event.caster) && SpellSchools.ELEMENTAL_WATER.isPartOfSchool(event.spellPart)) {
            event.builder.addDamageModifier(2.0);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isInWater() && this.level().getGameTime() % 60L == 0L && this.getOwner() != null) {
            this.getOwner().addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 600, 1, false, false, true));
            this.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 600, 1, false, false, true));
        }
        if (!this.level().isClientSide && this.level().getGameTime() % 10L == 0L && this.getName().getString().toLowerCase(Locale.ROOT).equals("jeb_")) {
            this.entityData.set(COLOR, (Object)MermaidEntity.Variants.random().toString());
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        super.registerControllers(data);
        data.add(new AnimationController((GeoAnimatable)this, "actionController", 10, event -> event.setAndContinue(this.getDeltaMovement().length() > 0.0 || this.level().isClientSide && PatchouliHandler.isPatchouliWorld() ? this.swim : this.idle)));
    }

    public PlayState walkPredicate(AnimationState event) {
        return event.setAndContinue(this.onGround() && !this.isInWater() || this.level().isClientSide && PatchouliHandler.isPatchouliWorld() ? this.ground : this.floating);
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.SIREN_FAMILIAR.get();
    }

    protected PathNavigation createNavigation(Level world) {
        PathNavigation newNav = super.createNavigation(world);
        newNav.setCanFloat(false);
        return newNav;
    }

    public ResourceLocation getTexture() {
        return ArsElemental.prefix("textures/entity/mermaid_" + (this.getColor().isEmpty() ? MermaidEntity.Variants.KELP.toString() : this.getColor()) + ".png");
    }
}

